%path to fast intersection kernel SVM
addpath /home/eecs/smaji/vision/tools/classifiers/libsvm-mat-2.84-1-fast.v3/

load ct101_meta.mat %metadata

% base directory for the caltech images
meta.base_dir = '../data/101_ObjectCategories/'; 

%parameters for the descriptor
nbins=8;
nl=4;
canny_sigma = 1;
canny_thresh = 0.2;
nbinsSVM=100; %#bins for piecewise linear approximation


% compute descriptor for each image, store in cell array called ad
% (all descriptors)
% takes about 40 mins on one machine
% there is a precomputed version in descriptors_2_8_4.mat
% this has 2 sets of oe histograms (ala lazebnik's work and slightly different from the code below)
count=size(images.im_name,2);

dodesc=0; 

if(dodesc)
    fprintf(1,'Computing descriptors..');
    tic
    for j=1:nl,
    ad{j}=zeros(nbins*4^(j-1),count);
    end
    for ind=1:count,
        I = imread([meta.base_dir images.cat_names{images.cat(ind)} '/' images.im_name{ind}]);
        descriptor = compute_sp_hog(I,nbins,nl,canny_thresh,canny_sigma);
        for j=1:length(descriptor),
            d =descriptor{j}';
            ad{j}(:,ind) = d(:);
        end
        fprintf('done %d of %d\r',ind,count);
    end
    toc
    % this is commented out to avoid over writing the descriptor file
    save descriptors_1_8_4.mat ad
else
    fprintf(1,'Loading precomputed descriptors..');
    load descriptors_2_8_4.mat ad
end;
fprintf(1,'[done]\n');



% put the desriptors into a matrix, one col for each image
% count how many components are in a descriptor
tl = 0;
for i=1:length(ad),
  tl = tl + size(ad{i},1);
end

count=size(ad{1},2);

% add will be the matrix of descriptors, with some weight for each level
add = zeros(tl,count);
cl=0;
for i=1:length(ad), % looping through levels
  adn = ad{i};
  s=sum(adn);
  adn = adn./repmat(s,[size(adn,1) 1]);
  add(cl+1:cl+size(ad{i},1),:)=(4^i)*adn;
  cl=cl+size(ad{i},1);
end


% make nadd, L1  normalized add
s = sum(add);
nadd = add./repmat(s,[size(add,1), 1]);
nadd=nadd';


rand('twister', 1000); %added for repeatability 

% make training / test split
dosplit=1;
if(dosplit)
    ntrain = 15;
    ntest = 15;
    all_train=[];
    all_test=[];
    all_train_cat = [];
    all_test_cat = [];
    for i=1:102,
      w = find(images.cat==i);
      rp = randperm(length(w));
      train{i} = w(rp(1:ntrain));
      test{i} = w(rp(ntrain+1:min(ntest+ntrain,length(w))));
      all_train = cat(1,all_train,train{i}(:));
      all_test = cat(1,all_test,test{i}(:));
      all_train_cat = cat(1,all_train_cat,i*ones(ntrain,1));
      all_test_cat = cat(1,all_test_cat,i*ones( length(test{i}), 1));
    end

    training_vecs = nadd(all_train,:);
    testing_vecs = nadd(all_test,:);
end

do_one_vs_one=1;
if(do_one_vs_one) %faster but less accurate
    fprintf(1,'1-vs-1 classifiers:\n');
    % linear kernel 
    tic;
    big_model= svmtrain(all_train_cat, training_vecs,'-t 0 -c 10000');
    [pd,acc,pv]= svmpredict(all_test_cat, testing_vecs,big_model);
    toc; %(43 seconds, 40.0% accuracy)

    % intersection kernel
    tic;
    big_model_int = svmtrain(all_train_cat, training_vecs,'-t 4 -c 10000');
    [pd_int ,acc_int ,pv_int ]= svmpredict(all_test_cat, testing_vecs,big_model_int);
    toc; %(47 seconds, 47.3% accuracy)
    
else
    fprintf(1,'1-vs-all classifiers:\n');
    all_scores_int_fast = zeros(length(testing_vecs),102);
    
    dotrain=1;
    %% Training
    if(dotrain);
        clear model_int;
        disp('Training');
        tic;
        for i=1:102,
            fprintf(1,'%d..',i);
            model_int{i}=  svmtrain((all_train_cat==i)+1, training_vecs,'-w2 10 -t 4 -c 1000 -b 1');
        end;
        toc; %(800 seconds)
    end
    if(1)
    all_scores_int = zeros(length(testing_vecs),102);
    disp('Testing');
    tic;
    for i=1:102,
        fprintf(1,'Category %d: ',i);
        [pl,acc,dv]=svmpredict((all_test_cat==i)+1,testing_vecs,model_int{i},'-b 1');
        all_scores_int(:,i)=dv(:,model_int{i}.Label==2);
    end;
    stime = toc; %(135 seconds)
    end;
    
    sacc_e = getacc(all_scores_int,all_test_cat);
    
    disp('fast Testing');
    nbinsSVM = [10 20 40 50 75 100];
    for nn = 1:length(nbinsSVM)
        teststr = sprintf('-b 1 -n %d',nbinsSVM(nn));
        disp(teststr);
        tic;
        for i=1:102,
            %fprintf(1,'Category:%d\n',i);
            [e, pwc, pwl,ft(i,:)]=fastpredict((all_test_cat==i)+1,testing_vecs,model_int{i},teststr);
            fe(:,i) =e(:,model_int{i}.Label==2);    %exact
            fpwc(:,i)=pwc(:,model_int{i}.Label==2); %piecewise constant
            fpwl(:,i)=pwl(:,model_int{i}.Label==2); %piecewise linear
        end;
        toc; %(24 seconds)
        acc_e(nn)   = getacc(fe,all_test_cat);
        acc_pwc(nn) = getacc(fpwc,all_test_cat);
        acc_pwl(nn) = getacc(fpwl,all_test_cat);
        times(nn,:) = sum(ft);
    end        
end

%plot pretty graphs
for i = 1:length(model_int);
    ns(i)=sum(model_int{i}.nSV);
end

%error rate vs number of bins
figure;
hold on;
plot(nbinsSVM,1-acc_e,'--r*');
plot(nbinsSVM,1-acc_pwc,'--g*');
plot(nbinsSVM,1-acc_pwl,'--b*');
legend('exact (binary search)','approx (piecewise constant)',['approx (piecewise ' ...
                    'linear)']);
title('Error vs. Number of Bins');

xlabel('Number of Bins');
ylabel('Error');
grid on;
set(gca,'XTick',nbinsSVM)

figure;
hold on;
plot(nbinsSVM,times(:,1),'--k*');
plot(nbinsSVM,times(:,2),'--r*');
plot(nbinsSVM,times(:,3),'--g*');
plot(nbinsSVM,times(:,4),'--b*');
legend('precomp','exact (binary search)','approx (piecewise constant)',['approx (piecewise ' ...
                    'linear)']);

title(sprintf('Classification Time (libsvm=%.2fs , %.2f mean sup vec, %d dim features)',stime,mean(ns),size(testing_vecs,2)));
xlabel('Number of Bins');
ylabel('Classification Time(s)');
grid on;
set(gca,'XTick',nbinsSVM);

