function descriptor = compute_sp_hog(I,nbins,nl,canny_thresh,canny_sigma)

if (~isfloat(I)),
  I = im2double(I);
end

if (size(I,3)>1),
  I = 0.3*I(:,:,1) + 0.59*I(:,:,2) +  0.11 * I(:,:,3);  
end




%%%
%%%  Compute Canny edge map, 
%%%
%%%  Note: that we need to change the ...
%%%  threshold to (0.2) from the default of (0.1) 
%%%

% c1 = edge(I,'canny'); % doesn't match using the default threshold
c2 = edge(I,'canny',canny_thresh,canny_sigma);


%%%
%%%  Compute directional derivatives using Sobel filter (sort of)
%%%   
%%%  Note that we actually use [-1 0 1] filters instead of the
%%%  common Sobel filter[1 2 1]'*[1 0 -1]
%%%

% sobel_x = [ 1 0 -1; 2 0 -2; 1 0 -1]/8;  %%% doesn't match paper
% sobel_y = sobel_x';  %%% doesn't match paper
 
% [bw,thresh,gv,gh]=edge(I,'sobel');    %%% doesn't match paper

% make the derivative filters
 paper_x = [ 0 0 0; 1 0 -1; 0 0 0]/2;
 paper_y = paper_x';



% apply the derivative filters
sx = conv2(I,flipud(fliplr(paper_x)),'same');
sy = conv2(I,flipud(fliplr(paper_y)),'same');

% compute edge direction using atan
[X,Y]=meshgrid([1:size(sx,2)],[1:size(sx,1)]);

mask = (c2>0);

X=X(mask); Y=Y(mask);
X=(X-1)/(size(sx,2)-1); Y=(Y-1)/(size(sx,1)-1);
sx=sx(mask); sy=sy(mask);


a = atan(sy./sx);
m = ((sx.^2)+(sy.^2)).^0.5;  % edge magnitude

% only take gradient mag where there was canny response above threshold.
%a=a(c2>0);
%m=m(c2>0);


% make bins and compute histogram
min_bin = -pi/2;
max_bin = pi/2;
%nbins = 20;
bin_size = (max_bin-min_bin)/nbins;
center_offset = bin_size/2;
bin_centers = (min_bin+center_offset):bin_size:(max_bin-center_offset);
bin = min(nbins,max(1,round(nbins*(a-min_bin)/(max_bin-min_bin)+0.5)));
for i=1:nl,
  f=zeros(4.^(i-1),nbins);
  xi = max(1,min(2.^(i-1),round(X*(2.^(i-1))+0.5)));
  yi = max(1,min(2.^(i-1),round(Y*(2.^(i-1))+0.5)));
  sbi = (xi-1)*(2.^(i-1))+yi;
  for j=1:length(sbi),
    v=f(sbi(j),bin(j));
    f(sbi(j),bin(j))=v+m(j);
  end
  descriptor{i}=f;
end

