% code to do 1-vs-all classification on caltech 101
% function [A,T] = classify_one_vs_all(all_train_cat,training_vecs,all_test_cat, testing_vecs,params)
% [A,T] = accuracy and training times
% all_train_cat - category vector for the training examples


function [A,T] = classify_one_vs_all(all_train_cat,training_vecs,all_test_cat, testing_vecs,params)
use_sqrt        = params.use_sqrt;
ndivs           = params.ndivs;
pwl_lambda      = params.pwl_lambda;
pwc_lambda      = params.pwc_lambda;
k               = params.k;
C               = params.C;
class_1_weight  = params.class_1_weight;
iters           = params.iters;

tic;
x_train = single(training_vecs');
x_test  = single(testing_vecs');

mins = min(x_train,[],2)';
maxs = max(x_train,[],2)';
nsteps = ndivs*ones(1,size(x_train,1));
step = (maxs-mins)./nsteps;
if (sum(step<=0)>0)
  fprintf(' small steps?\n');
end
seg_data = single(cat(1,mins,maxs,step,nsteps));

%compute sparse represenations for test and train
[dummy,ii_train,jj_train,val_train] = pwl_sgd( x_train , seg_data, single(all_train_cat'), k, 0, pwl_lambda, 0, 0,use_sqrt,1);
[dummy,ii_test,jj_test,val_test] = pwl_sgd( x_test , seg_data, single(all_test_cat'), k, 0, pwl_lambda, 0, 0,use_sqrt,1);

sparse_train = sparse(double(ii_train),double(jj_train), double(val_train),sum(nsteps),length(all_train_cat));
sparse_test = sparse(double(ii_test),double(jj_test), double(val_test),sum(nsteps),length(all_test_cat));

t=toc;
fprintf('%.2fs to encode features..\n',t);
clear dummy ii_train ii_test jj_train jj_test val_train val_test;

enc_svm_type=params.enc_svm_type; % the svm type for liblinear (l1 loss)

fprintf('Training 1-vs-all classifiers (liblinear + encoded)\n');

%do it once 
str = sparse_train';
ste = sparse_test';

% liblinear on encoded features
% l1 loss svm followed by logistic regression for probability estimates
tic;
    svmstr = sprintf('-w2 %i -s %i -c %d -B %d',class_1_weight,enc_svm_type,C,-1); %10 - 47.46
    probstr = sprintf('-w2 %i -s 0 -c %d',class_1_weight,10);
    for i=1:102,
        enc_model{i} = train((all_train_cat==i)+1,sparse_train,svmstr,'col');
        if(enc_svm_type ~= 0) %train a probability model too
            [p,l,dv] = predict((all_train_cat==i)+1,str,enc_model{i});
            enc_prob{i} = train((all_train_cat==i)+1,sparse(dv),probstr);
        end
    end;
t=toc; 
fprintf('%.2fs to train all models..\n',t);

all_scores_enc = zeros(length(all_test_cat),102);
tic;
for i=1:102,
    if(enc_svm_type == 0) %if trained using logistic regression
        [pl,acc,dv]=predict((all_test_cat==i)+1,sparse_test,enc_model{i},'-b 1','col');
        all_scores_enc(:,i)=dv(:,enc_model{i}.Label==2);
    else %l1 loss + logistic regression
        [pl,acc,dv]=predict((all_test_cat==i)+1,ste,enc_model{i});
        [pl2,acc2,dv2]=predict((all_test_cat==i)+1,sparse(dv),enc_prob{i},'-b 1');
        all_scores_enc(:,i)=dv2(:,enc_prob{i}.Label==2);
     end
end;
te = toc;
enc_acc = getacc(all_scores_enc,all_test_cat);
fprintf('%.2fs train , %.2fs predict, C = %f, acc = %f\n',t,te,C, enc_acc);
%liblinear numbers
A.enc_acc = enc_acc;
T.enc_train = t;
T.enc_test  = te;

% piecewise linear using sgd
probstr = sprintf('-w2 %i -s 0 -c %d',10,0.1);
tt = 0;
for i=1:102,
    tic;
    [w,ii,jj,val]=pwl_sgd( x_train , seg_data, 2*single(all_train_cat==i)'-1, k, iters, ...
                                pwl_lambda,1,0,use_sqrt,class_1_weight);
    pwl_model{i} = w;
    dv = pwl_model{i}'*sparse_train;
    sum((2*single(all_train_cat==i)'-1).*sign(dv) > 0)
    max(dv)
    enc_prob{i} = train((all_train_cat==i)+1,sparse(dv)',probstr);
    t = toc;
    tt = tt + t;
    fprintf(1,'%.2fs to train category %i \n',t,i);
end;
clear ii jj val;
fprintf('%.2fs to train all models.\n',tt); %45s

all_scores_pwl = zeros(length(all_test_cat),102);
tic;
for i=1:102,
    dv = pwl_model{i}'*sparse_test;
    [pl2,acc2,dv2]=predict((all_test_cat==i)+1,sparse(dv)',enc_prob{i},'-b 1');
    all_scores_pwl(:,i)=dv2(:,enc_prob{i}.Label==2);
end;
te = toc; %(3.0976)
pwl_acc = getacc(all_scores_pwl,all_test_cat);
fprintf('%.2fs train , %.2fs predict, lambda = %f, acc = %f\n',tt,te,pwl_lambda, pwl_acc);
A.pwl_acc = pwl_acc;
T.pwl_train = tt;
T.pwl_test  = te;

% piecewise constant using sgd
probstr = sprintf('-w2 %i -s 0 -c %d',10,0.1);
tt = 0;
for i=1:102,
    tic;
    [w,ii,jj,val]=pwl_sgd( x_train , seg_data, 2*single(all_train_cat==i)'-1, k, iters, ...
                                pwc_lambda,0,0,use_sqrt,class_1_weight);
    pwc_model{i} = w;
    dv = pwc_model{i}'*sparse_train;
    sum((2*single(all_train_cat==i)'-1).*sign(dv) > 0)
    max(dv)
    enc_prob{i} = train((all_train_cat==i)+1,sparse(dv)',probstr);
    t = toc;
    tt = tt + t;
    fprintf(1,'%.2fs to train category %i \n',t,i);
end;
clear ii jj val;
fprintf('%.2fs to train all models.\n',tt); %45s

all_scores_pwc = zeros(length(all_test_cat),102);
tic;
for i=1:102,
    dv = pwl_model{i}'*sparse_test;
    [pl2,acc2,dv2]=predict((all_test_cat==i)+1,sparse(dv)',enc_prob{i},'-b 1');
    all_scores_pwc(:,i)=dv2(:,enc_prob{i}.Label==2);
end;
te = toc; %(3.0976)
pwc_acc = getacc(all_scores_pwc,all_test_cat);
fprintf('%.2fs train , %.2fs predict, lambda = %f, acc = %f\n',tt,te,pwc_lambda, pwc_acc);
A.pwc_acc = pwc_acc;
T.pwc_train = tt;
T.pwc_test  = te;

end
