data = csvread('book-data.csv');

% Data columns
%
% 1 - width
% 2 - thickness
% 3 - height
% 4 - pages
% 5 - hardcover
% 6 - weight

features = data(:,1:5);
y = data(:,6);
N = length(y);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Predict with existing features
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

X = [ones(N,1) features];

w = normal_equations(X, y);

fprintf('Original features: cost is %.4f\n', cost_function(X, y, w));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Add new feature which is the sum of first two
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

new_feature = features(:,1) + features(:,2);

X = [ones(N,1) features new_feature]; % NB: concatenation of vectors

w = normal_equations(X, y);

fprintf('Add new feature: cost is %.4f\n', cost_function(X, y, w));
