%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Create the problem
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

rng('default'); % reset the random number generator

% Create a column vector of input x values 
x = (-1:0.01:1)';
N = length(x);

% Generate features: 1, x, x^2, x^3, x^4
X = [ones(N,1) x x.^2 x.^3 x.^4];

% Define a weight vector w, which specifies a polynomial
%
%   y = w(1) + w(2)*x + w(3)*x^2 + w(4)*x^3 + w(5)*x^4

w = [1; -3; 2; 5; -2];

% Generate output data from true polynomial, but add a little random noise
y = X*w + randn(N, 1)*0.5;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Solve the problem
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

w_learned = normal_equations(X, y);

fprintf('The true coefficients are:\n');
disp(w);

fprintf('The learned coefficients are:\n');
disp(w_learned);

J = cost_function(X, y, w_learned);

fprintf('The final cost is %.4f\n', J);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Plot the original data and the results
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

figure(1); clf; hold on; set(gca, 'Fontsize', 15);

y_original  = X*w;
y_predicted = X*w_learned;
plot(x, [y_original y_predicted], 'linewidth', 2);
scatter(x, y);

xlabel('x');
ylabel('y');
legend('Original', 'Learned', 'Data');
