% THIS IS A COMMENT!

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Assignment, entering data, accessing data, printing output
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Syntax for entering a matrix
A = [1 4; -1 7; 3 0]

% Alternate syntax
A = [1 4
    -1 7
     3 0]
 
% Enter a row vector
x = [2 -1]

% Enter a column vector
x = [2; -1]

% Enter a scalar
z = 2

% Concatenation
x = [1
     2];
 
y = [3
     4];
 
A = [x y]

B = [A A]

C = [A; A]

% Create vectors of equally spaced numbers
x = 1:10      % [1 2 3 4 5 6 7 8 9 10]

x = 0:0.1:0.5 % [0 0.1 0.2 0.3 0.4 0.5]

x = 5:-1:1    % [5 4 3 2 1]

% Access the entries of a vector
x(1)
x(2)

% Access the entries of a matrix
A(1,2)
A(2,1)
% A(2,3) --> error!

% Access entire rows and columns using : indexing
row1 = A(1,:)
col2 = A(:,2)

% Size of a matrix or vector
[m,n] = size(A)

% Print output
disp(A)
fprintf('A has %d rows and %d columns\n', m, n);
fprintf('The square root of 2 is %.4f\n', sqrt(2));

% Lenth of a vector
length(x)

% Built-in functions to create special matrices
Z = zeros(4,2)  % 4 x 2 matrix of zeros
z = zeros(2,1)  % 2 x 1 matrix of zeros 
E = ones(3,3)   % 3 x 3 matrix of ones
I = eye(2)      % 2 x 2 identity matrix
R = rand(3,2)   % 3 x 2 matrix of random numbers in [0,1]

% Clear (undefine) all variables from the workspace
clear all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Operations: addition, multiplication, transpose, inverse
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

A = [1 2
     3 4];
 
B = [1 0
     0 2];
 
x = [2; 1];

c = 2;

% Scalar multiplication
c*A

% Matrix multiplication
A*B

% Element-wise multiplication, division
A.*B
B./A
% A./B --> error: divide by zero

% Matrix-vector multiplication
A*x

% Matrix addition
A + B

% Matrix plus scalar
c + A

% Matrix transpose
A'

% Vector transpose
x'

% Dot product
x'*x

% Matrix inverse
inv(A)

% Matrix pseudoinverse (use this for normal equations)
pinv(A)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Control flow: for loops
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

A = [1 4
    -1 7
     3 0]

[m,n] = size(A);
 
% For loop to access all rows
for i=1:m
    A(i,:)
end

% For loop to access all columns
for j=1:n
    A(:,j)
end

% While loop
counter = 10;
while counter > 0
    counter = counter - 1
end

% If statement
x = 10;

if x > 5
    fprintf('Yes!!\n');
end

if x < 5 
    fprintf('NOOOOOOOOO!!!!\n');
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Plotting
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all

x = (-5:.1:5)';
y1 = x.^2/10;
y2 = sin(x);
plot(x, y1);

plot(x, [y1 y2]);
