
experiment = 1;   % Change this to run difference experiments

% Select a set of parameters to illustrate different points
switch experiment

    case 1  % Linearly separable, hard margin, no outlier
        
        load data/data1.mat
        
        % remove outlier
        X = X(1:end-1,:);
        y = y(1:end-1);
        
        kernel_type = 0;
        show_margin = true;
        show_sv     = true;
        gamma_vals  = 0;
        c_vals      = 100;

    case 2  % Add outlier. See how it affects decision boundary
        
        load data/data1.mat
        
        kernel_type = 0;
        show_margin = true;
        show_sv     = true;
        gamma_vals  = 0;
        c_vals      = [100];

    case 3  % Soft margin fixes decision boundary. Vary C
        
        load data/data1.mat
        
        kernel_type = 0;
        show_margin = true;
        show_sv     = true;
        gamma_vals  = 0;
        c_vals      = [100 10 1 .1];
        
    case 4  % Gaussian kernel. Effect of c

        load data/data2.mat

        kernel_type = 2;
        show_margin = true;
        show_sv     = false;
        gamma_vals  = 50;
        c_vals      = [1e3 100 10 1 .1];
        
        
    case 5  % Gaussian kernel. Effect of gamma
        
        load data/data2.mat
        
        kernel_type = 2;
        show_margin = true;
        show_sv     = false;
        c_vals      = 10;
        gamma_vals  = [.1 1 10 100 1e3 1e4 1e5];


end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Visualize the SVM for each combination of parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
lw = 2;

% Look at data only
figure(1);
clf();
visualizeBoundary(y, X);

fprintf('Press any key to continue\n');
pause;

for i = 1:length(gamma_vals)
    for j = 1:length(c_vals)
        
        gamma = gamma_vals(i);
        c = c_vals(j);
        
        args = sprintf('-t %d -c %.4f -g %.4f', kernel_type, c, gamma);
        model = svmtrain(y, X, args);
        
        figure(1);
        clf;
        
        if kernel_type == 2            
            subplot('Position', [0.1 0.3 0.8 0.65]); 
            set(gca, 'Fontsize', 15);
            visualizeBoundary(y, X, model, show_margin, show_sv);
            title(sprintf('C=%.2e, gamma = %.2e, nSV = %d', c, gamma, sum(model.nSV)));

            subplot('Position', [0.1 0.05 0.8 0.2]);            
            set(gca, 'Fontsize', 15);
            x = 0:.001:1;
            plot(x, exp(-gamma*(x-0.5).^2), 'linewidth', lw);
            ylim([0 1]);
            
        else
            visualizeBoundary(y, X, model, show_margin, show_sv);
            title(sprintf('C=%.2e, nSV = %d', c, sum(model.nSV)));
        end
        
        fprintf('Press any key to continue\n');
        pause;
    end
end