
load data/digits.mat;   % Imports X_train, y_train, X_test, y_test into your MATLAB environment

addpath ./libsvm;       % Adds libsvm directory to the MATLAB path

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Linear support vector machine
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Sort training data by class so we can interpret the one-vs-one-comparisons
model = svmtrain(y_train, X_train, '-t 0 -c 1');

pred_train = svmpredict(y_train, X_train, model);
pred_test  = svmpredict(y_test,  X_test,  model);

fprintf('\nTraining Set Accuracy: %f\n', mean(double(pred_train == y_train)) * 100);
fprintf(  '    Test Set Accuracy: %f\n', mean(double(pred_test  == y_test))  * 100);

svm_weight_vectors = svm_extract_weights(model);
display_data(svm_weight_vectors);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% RBF kernel support vector machine
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

model = svmtrain(y_train, X_train, '-c 10 -t 2 -g .1');

pred_train = svmpredict(y_train, X_train, model);
pred_test  = svmpredict(y_test,  X_test,  model);

fprintf('\nTraining Set Accuracy: %f\n', mean(double(pred_train == y_train)) * 100);
fprintf(  '    Test Set Accuracy: %f\n', mean(double(pred_test  == y_test))  * 100);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Display support vectors
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[~, SVs] = svm_extract_weights(model);

n_display = 36;

for c=1:10
    figure(1);
    clf();
    display_data(SVs{c}(1:n_display,:));
    pause;
end
