
load data/digits.mat;   % Imports X_train, y_train, X_test, y_test into your MATLAB environment

addpath ./libsvm;       % Adds libsvm directory to the MATLAB path

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Run a small grid search to find the best values of c and gamma
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

c_vals     = 10.^[-1  0 1]; % test three values of c
gamma_vals = 10.^[-2 -1 0]; % test three values of gamma

% Set up some data stuctures to hold results
m = length(c_vals);
n = length(gamma_vals);

train_accuracy = zeros(m,n);
test_accuracy = zeros(m,n);

% Run the grid search
for i=1:m
    for j = 1:n

        c = c_vals(i);
        gamma = gamma_vals(j);

        fprintf('********* C = %.4e, Gamma = %.4e ***********\n', c, gamma);
        fprintf('  Training\n');
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % Understand this code for constructing the argument string
        % and calling libsvm
        
        args = sprintf('-t 2 -c %.4e -g %.4e', c, gamma);   
        
        model = svmtrain(y_train, X_train, args); % train

        pred_train = svmpredict(y_train, X_train, model); % predict on training set
        pred_test  = svmpredict(y_test,  X_test,  model); % predict on test set

        %
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        train_accuracy(i,j) = mean(double(pred_train == y_train)) * 100;
        test_accuracy(i,j) = mean(double(pred_test  == y_test))  * 100;
        
        fprintf('  Training Set Accuracy: %f\n', train_accuracy(i,j));
        fprintf('      Test Set Accuracy: %f\n', test_accuracy(i,j));
        
    end
end

