rng('default');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Load the data
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all; clear; clc;

data = csvread('book-data.csv');

% Data columns
%
% 1 - width
% 2 - thickness
% 3 - height
% 4 - pages
% 5 - hardcover
% 6 - weight

y = data(:,5);

% Extract the normalized features into named column vectors
width     = data(:,1);
thickness = data(:,2);
height    = data(:,3);
pages     = data(:,4);
weight    = data(:,6);

m = size(data,1);

% Create data matrix using only two features plus constant column
X = [ones(m,1) thickness height];

n = size(X,2);

X = normalize_features(X);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit the model and print out accuracy
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

theta = zeros(n,1);  % debug your cost function: 
                     % the cost of this theta is 38.8162


                     
% YOUR CODE HERE
%  1) call gradient descent to learn theta
%  2) plot J_history
%  3) tune the step size and number of iterations if neeeded
%  4) print the accuracy---the percentage of correctly classified examples
%     in the training set


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Visualize the result
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

figure(2); 
clf();
hold on;

% plot data (train and test)
pos = y==1;
neg = y==0;
scatter(X(pos,2), X(pos,3), '+');
scatter(X(neg,2), X(neg,3), 'o');

% plot the decision boundary
x1 = [min(X(:,2))-0.5 max(X(:,2))+0.5];
x2 = (theta(1) + theta(2)*x1)./(-theta(3));
line(x1, x2);

xlabel('thickness (normalized)');
ylabel('height (normalized)');

legend('Hardcover', 'Paperback', 'Decision boundary');
