#ifndef _VALUEITERATION_HPP_
#define _VALUEITERATION_HPP_

#include "Environment.hpp"
#include "Multilinear.hpp"
#include <random>
#include <string>

enum MaxQVariantType {MQV_Ordinary, MQV_Consistent};

void runValueIteration(Environment & e, const ENVTYPE & type, Multilinear & d, MaxQVariantType maxQVariant, bool valueAveraging,
                       std::mt19937_64 & generator, int numIterations, const int evaluateFreq,
                       int numThreads_VI, int numThreads_PE, const std::string & fileName);

// Some other functions that might be used elsewhere
double Q(const Eigen::MatrixXd & W, const Eigen::VectorXd & state, int a, Multilinear & d);
int greedyAction(const Eigen::MatrixXd & W, const Eigen::VectorXd & state, Multilinear & d);

#endif // _VALUEITERATION_HPP_
