#include "Environment.hpp"
#include "MountainCar.hpp"
#include "PuddleWorld.hpp"
#include "Acrobot.hpp"
#include "CartPole.hpp"
#include "Pendulum.hpp"
#include "Bicycle.hpp"

using namespace std;

Environment * createEnvironment(const ENVTYPE & type, mt19937_64 & generator) {
	Environment * e;
	switch (type) {
		case et_MountainCar:
			e = new MountainCar(generator);
			return e;
		case et_PuddleWorld:
			e = new PuddleWorld(generator);
			return e;
		case et_Acrobot:
			e = new Acrobot(generator);
			return e;
		case et_CartPole:
			e = new CartPole(generator);
			return e;
		case et_Pendulum:
			e = new Pendulum(generator);
			return e;
		case et_Bicycle:
			e = new Bicycle(generator);
			return e;
		default:
			return nullptr;
	}
}
