/* command.c - Command line argument processing */

#include "general.h"

char *read_com_string(int *p_argc, char **argv, char *label) {
    int i;
    char *temp;

    for (i = 1; i < *p_argc - 1; i++) {
        if (!strcmp(argv[i], label)) {
            temp = argv[i+1];
            remove_arg(p_argc, argv, i+1);
            remove_arg(p_argc, argv, i); 
            return(temp);
        }
    }
    return(NULL);
}

int read_com_float(int *p_argc, char **argv, char *label, float *p_value) {
    int i;

    for (i = 1; i < *p_argc - 1; i++) {
        if (!strcmp(argv[i], label)) {
            *p_value = (float) atof(argv[i+1]);
            remove_arg(p_argc, argv, i+1);
            remove_arg(p_argc, argv, i);
            return(1);
        }
    }
    return(0);
}

int read_com_double(int *p_argc, char **argv, char *label, double *p_value) {
    int i;

    for (i = 1; i < *p_argc - 1; i++) {
        if (!strcmp(argv[i], label)) {
            *p_value = (double) atof(argv[i+1]);
            remove_arg(p_argc, argv, i+1);
            remove_arg(p_argc, argv, i);
            return(1);
        }
    }
    return(0);
}

int read_com_int(int *p_argc, char **argv, char *label, int *p_value) {
    int i;

    for (i = 1; i < *p_argc - 1; i++) {
        if (!strcmp(argv[i], label)) {
            *p_value = atoi(argv[i+1]);
            remove_arg(p_argc, argv, i+1);
            remove_arg(p_argc, argv, i);
            return(1);
        }
    }
    return(0);
}

int read_com_two_int(int *p_argc, char **argv, char *label, int *p_value1, int *p_value2) {
    int i;

    for (i = 1; i < *p_argc - 1; i++) {
        if (!strcmp(argv[i], label)) {
            *p_value1 = atoi(argv[i+1]);
            *p_value2 = atoi(argv[i+2]);
            remove_arg(p_argc, argv, i+2);
            remove_arg(p_argc, argv, i+1);
            remove_arg(p_argc, argv, i);
            return(1);
        }
    }
    return(0);
}

char *read_com_one_string_two_int(int *p_argc, char **argv, char *label, int *p_value1, int *p_value2) {
    int i;
    char *temp;

    for (i = 1; i < *p_argc - 1; i++) {
        if (!strcmp(argv[i], label)) {
            temp = argv[i+1];
            *p_value1 = atoi(argv[i+2]);
            *p_value2 = atoi(argv[i+3]);
            remove_arg(p_argc, argv, i+3);
            remove_arg(p_argc, argv, i+2);
            remove_arg(p_argc, argv, i+1);
            remove_arg(p_argc, argv, i);
            return(temp);
        }
    }
    return(NULL);
}

int read_com_noarg(int *p_argc, char **argv, char *label) {
    int i;

    for (i = 1; i < *p_argc; i++) {
        if (!strcmp(argv[i], label)) {
            remove_arg(p_argc, argv, i);  
            return(1);
        }
    }
    return(0);
}

void check_extra_args(int *p_argc, char **argv) {
    int i, found = 0;

    for (i = 1; i < *p_argc; i++) {
        fprintf(stderr, "ERROR: Unknown argument: %s\n", argv[i]);
        found = 1;
    }
    if (found) quit(-1, "Exiting...\n");
}

void remove_arg(int *p_argc, char **argv, int to_remove) {
    int i;
    char *temp;

    temp = argv[to_remove];
    for (i = to_remove; i < *p_argc-1; i++) {
        argv[i] = argv[i+1];
    }
    argv[*p_argc-1] = temp;
    (*p_argc)--;
}



