function varargout = DigitDemo(varargin)
% DIGITDEMOGUI M-file for DigitDemo.fig
%      DIGITDEMOGUI, by itself, creates a new DIGITDEMOGUI or raises the existing
%      singleton*.
%
%      H = DIGITDEMOGUI returns the handle to a new DIGITDEMOGUI or the handle to
%      the existing singleton*.
%
%      DIGITDEMOGUI(%'Callback',hObject,eventData,handles,...) calls the
%      local
%      function named CALLBACK in DIGITDEMOGUI.M with the given input arguments.
%
%      DIGITDEMOGUI('Property','Value',...) creates a new DIGITDEMOGUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before DigitDemo_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to DigitDemo_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help DigitDemo

% Last Modified by GUIDE v2.5 07-May-2010 21:16:31  

% Begin initialization code - DO NOT EDIT

if(verLessThan('matlab','7.2'))
  error('The DigitDemo GUI requires Matlab version 7.2 (R2006a) or above to function correctly.')
  return
end

gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @DigitDemo_OpeningFcn, ...
                   'gui_OutputFcn',  @DigitDemo_OutputFcn, ...
                   'gui_LayoutFcn',  @DigitDemo_LayoutFcn, ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT




% --- Executes just before DigitDemo is made visible.
%function DigitDemo_OpeningFcn(hObject, eventdata, handles, varargin)
function DigitDemo_OpeningFcn(varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to DigitDemo (see VARARGIN)


hObject=varargin{1};
eventdata=varargin{2};
handles=varargin{3};
varargin=varargin(4:end);

% Choose default command line output for DigitDemo
handles.output = hObject;

% UIWAIT makes DigitDemo wait for user response (see UIRESUME)
% uiwait(handles.figure1);
handles.inputaxisfcnbk = get(handles.inputaxis,'ButtonDownFcn');
handles.input_image = zeros(28,28);
handles.inputaxisimage = imagesc(handles.input_image,'Parent',handles.inputaxis);
set(handles.inputaxis,'box','on','xtick',[],'ytick',[],'clim',[0 1]);
set(handles.inputaxisimage,'ButtonDownFcn',handles.inputaxisfcnbk)
set(handles.inputaxis,'ButtonDownFcn',[])
%set(handles.figure1,'colormap',gray);
handles.drawing = 0;
handles.brush = @(x)(full(sparse([1 1 2 2],[1 2 1 2],[1 1 1 1],x,x)));
handles.energy = [];
handles.images=[];
tic


load('sml_params.mat')
handles.model(1).Wrbm = Wrbm;
handles.model(1).Wclass = Wclass;

load('cd_params.mat')
handles.model(2).Wrbm = Wrbm;
handles.model(2).Wclass = Wclass;

load('pl_params.mat')
handles.model(3).Wrbm = Wrbm;
handles.model(3).Wclass = Wclass;

load('rm_params.mat')
handles.model(4).Wrbm = Wrbm;
handles.model(4).Wclass = Wclass;


handles.usemodel = 1;

% Update handles structure
guidata(hObject, handles);




% --- Outputs from this function are returned to the command line.
function varargout = DigitDemo_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



% --- Executes on mouse press over axes background.
function inputaxis_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to inputaxis (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

  p = get(handles.inputaxis,'CurrentPoint');
  x = round(p(1,1));
  y = round(p(1,2));
  if(2<=x & x<=27 & 2<=y & y<=27)
    handles.drawing=1;   
    I = get(handles.inputaxisimage,'cdata');
    I(y-1:y+1,x-1:x+1)=I(y-1:y+1,x-1:x+1)+handles.brush(3);
    I(I>1)=1;
    I(I<0)=0;
    set(handles.inputaxisimage,'cdata',I);
    guidata(hObject, handles);
  end

guidata(handles.figure1, handles);

% --- Executes on mouse motion over figure - except title and menu.
function figure1_WindowButtonMotionFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


if(handles.drawing)
  p = get(handles.inputaxis,'CurrentPoint');
  x = round(p(1,1));
  y = round(p(1,2));
  if(2<=x & x<=27 & 2<=y & y<=27)
    I = get(handles.inputaxisimage,'cdata');
    I(y-1:y+1,x-1:x+1)=I(y-1:y+1,x-1:x+1)+handles.brush(3);
    I(I>1)=1;
    I(I<0)=0;
    set(handles.inputaxisimage,'cdata',I);
    
    handles = prediction(handles);
    
    guidata(hObject, handles);
  end
end

function figure1_WindowButtonUpFcn(hObject, eventdata, handles)

  handles.drawing=0;
  handles=prediction(handles);
  guidata(hObject, handles);
  
  
% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over resetbutton.
function resetbutton_Callback(hObject, eventdata, handles)
% hObject    handle to resetbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
I = get(handles.inputaxisimage,'cdata');
I=I*0;
set(handles.inputaxisimage,'cdata',I);
handles.energy=[];
handles.images=[];
handles=prediction(handles);
guidata(hObject, handles);



% --- Executes on button press in brushbutton.
function inputbutton_Callback(hObject, eventdata, handles)
% hObject    handle to brushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of brushbutton

h=get(hObject,'SelectedObject');
control = get(h,'tag');

switch(control)
    case 'brushbutton'
        handles.brush = @(x)(fspecial('gaussian',x,1)/0.2);
    case 'pencilbutton'
        handles.brush = @(x)(full(sparse([1 1 2 2],[1 2 1 2],[1 1 1 1],x,x)));
    case 'noisebutton'
        handles.brush = @(x)(rand(x)-0.5);
    case 'eraserbutton'
        handles.brush = @(x)(-ones(x));
end
guidata(hObject, handles);

% --- Executes on button press in brushbutton.
function ipbutton_Callback(hObject, eventdata, handles)
% hObject    handle to brushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of brushbutton

h=get(hObject,'SelectedObject');
control = get(h,'tag');

switch(control)    
    case 'smlbutton'
        handles.usemodel = 1;
    case 'cdbutton'
        handles.usemodel = 2;
    case 'plbutton'
        handles.usemodel = 3;
    case 'rmbutton'
        handles.usemodel = 4;
end
figure1_WindowButtonUpFcn(hObject, eventdata, handles);
handles.energy=[];
guidata(hObject, handles);



function handles=prediction(handles,I)

 if(toc>0.1)
    tic; 
     
    if(nargin==1) 
      I = get(handles.inputaxisimage,'cdata');
    end
    I = I';
    ah = [I(:)',1]*handles.model(handles.usemodel).Wrbm;
    ph = 1./(1+exp(-ah));
    ph(end) = 1;
    ac = ph*handles.model(handles.usemodel).Wclass;
    yhat = exp(ac - logsum(ac,2));
    bar(handles.classaxis,0:9,yhat,'k');
    set(handles.classaxis,'xlim',[-0.5 9.5], 'ylim',[0 1]);
    
    
    Ihat = 1./(1+exp(-handles.model(handles.usemodel).Wrbm*ph'));
    Ihat = Ihat(1:784);
    Ihat = reshape(Ihat,[28 28])';
    imagesc(Ihat,'parent',handles.meanfieldaxis);
    set(handles.meanfieldaxis,'clim',[0 1],'box', 'off','xtick',[],'ytick',[]);
        
    [foo,ord]=sort(ah(1:end-1)'.*sum(abs(handles.model(handles.usemodel).Wclass(1:end-1,:)),2),'descend');
    c=1;
    IF = -1*ones(30*5-2,30*10-2);
    for i=1:10
        for j=1:5
            F = reshape(handles.model(handles.usemodel).Wrbm(1:end-1,ord(c)),[28 28])';
            F = F/max(abs(F(:)));
            IF((j-1)*30 + (1:28),(i-1)*30+ (1:28)) = F;
            c=c+1;
        end
    end
    imagesc(IF,'parent',handles.filteraxis);
    set(handles.filteraxis,'clim',[-1 1],'box', 'off','xtick',[],'ytick',[]);
    
    if(size(handles.images,1)==50)
        handles.images = handles.images(2:50,:);
    end    
    handles.images(end+1,:) = [I(:)',1];
    ah = handles.images*handles.model(handles.usemodel).Wrbm;    
    log1plusexpaZ = log1plusexpx(ah(:,1:500));
    bx = handles.model(handles.usemodel).Wrbm(1:785,501);
    E  = -(handles.images*bx + sum(log1plusexpaZ,2));
    plot(handles.energyaxis,E,'k-o','LineWidth',2, 'MarkerFaceColor','w');
    set(handles.energyaxis,'xlim',[0, length(E)],'xtick',[]);
    handles.energy = E;
    
    
 end

 
function handles = run_gibbs(hObject,handles)

    I = get(handles.inputaxisimage,'cdata');
    I = I';
    x = [I(:)',1];
    
    i=1;
    while(1);

      ah = x*handles.model(handles.usemodel).Wrbm;
      ph = 1./(1+exp(-ah));
      h  = bernoulli_sample(ph)'; 
      h(end)=1;
      
      ax = handles.model(handles.usemodel).Wrbm*h;
      px = 1./(1+exp(-ax));
      x  = bernoulli_sample(px)';
      x(end)=1;
      
      I = reshape(px(1:784),[28 28])';
      %set(handles.inputaxisimage,'cdata',I);
      %set(handles.meanfieldaxis,'clim',[0 1],'box', 'off','xtick',[],'ytick',[]);
      imagesc(I,'parent',handles.meanfieldaxis);
      set(handles.meanfieldaxis,'clim',[0 1],'box', 'off','xtick',[],'ytick',[]);

      %guidata(hObject, handles); 
      
      handles2 = guidata(hObject);
      handles.usemodel = handles2.usemodel;
      if(handles2.stopsample);
          break;
      end
      
      if(mod(i,10)==0)
        handles = prediction(handles,I);
        guidata(hObject, handles);
        i=1; 
      else
        pause(0.05);
      end   
      
      i=i+1;
      
    end

   

 
    
function ls = log1plusexpx(xx)

alpha = max(xx,0)-log(realmax)/2+2*log(2);
%ls = alpha+log(exp(-alpha) + exp(bsxfun(@minus,xx,alpha)));
ls = alpha+log(exp(-alpha) + exp(xx-alpha));

function ls = logsum(xx,dim)
% ls = logsum(x,dim)
%
% returns the log of sum of logs, summing over dimension dim
% computes ls = log(sum(exp(x),dim))
% but in a way that tries to avoid underflow/overflow
%
% basic idea: shift before exp and reshift back
% log(sum(exp(x))) = alpha + log(sum(exp(x-alpha)));
%

if(size(xx,dim)<=1) ls=xx; return; end

xdims=size(xx);
if(nargin<2) 
  nonsingletons=find(xdims>1);
  dim=nonsingletons(1);
end

alpha = max(xx,[],dim)-log(realmax)/2+2*log(xdims(dim));
repdims=ones(size(xdims)); repdims(dim)=xdims(dim);
%ls = alpha+log(sum(exp(bsxfun(@minus,xx,alpha)),dim));
ls = alpha+log(sum(exp(xx-repmat(alpha,repdims)),dim));

function s = bernoulli_sample(p)
  s = double(p>rand(size(p)));


% --- Executes on button press in samplestartbutton.
function samplestartbutton_Callback(hObject, eventdata, handles)
% hObject    handle to samplestartbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.stopsample=0;
guidata(hObject, handles);
handles = run_gibbs(hObject,handles);
guidata(hObject, handles);


% --- Executes on button press in stopsamplebutton.
function stopsamplebutton_Callback(hObject, eventdata, handles)
% hObject    handle to stopsamplebutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.stopsample=1;
guidata(hObject, handles);


% --- Creates and returns a handle to the GUI figure. 
function h1 = DigitDemo_LayoutFcn(policy)
% policy - create a new figure or use a singleton. 'new' or 'reuse'.

persistent hsingleton;
if strcmpi(policy, 'reuse') & ishandle(hsingleton)
    h1 = hsingleton;
    return;
end

appdata = [];
appdata.GUIDEOptions = struct(...
    'active_h', [], ...
    'taginfo', struct(...
    'figure', 1, ...
    'uipanel', 14, ...
    'axes', 13, ...
    'pushbutton', 7, ...
    'text', 2, ...
    'radiobutton', 9), ...
    'override', 0, ...
    'release', 13, ...
    'resize', 'none', ...
    'accessibility', 'Callback', ...
    'mfile', 1, ...
    'callbacks', 1, ...
    'singleton', 1, ...
    'syscolorfig', 1, ...
    'blocking', 0, ...
    'lastSavedFile', '', ...
    'lastFilename', '');
appdata.lastValidTag = 'figure1';
appdata.GUIDELayoutEditor = [];
appdata.initTags = struct(...
    'handle', [], ...
    'tag', 'figure1');


h1 = figure(...
'Units','characters',...
'Color',[0.701960784313725 0.701960784313725 0.701960784313725],...
'IntegerHandle','on',...
'Colormap',gray(256),...
'InvertHardcopy',get(0,'defaultfigureInvertHardcopy'),...
'MenuBar','none',...
'Name','DigitDemo',...
'NumberTitle','off',...
'PaperPosition',get(0,'defaultfigurePaperPosition'),...
'Position',[103.833333333333 0.928571428571428 193.5 60.5],...
'Resize','on',...
'WindowButtonMotionFcn',@(hObject,eventdata)DigitDemo('figure1_WindowButtonMotionFcn',hObject,eventdata,guidata(hObject)),...
'WindowButtonUpFcn',@(hObject,eventdata)DigitDemo('figure1_WindowButtonUpFcn',hObject,eventdata,guidata(hObject)),...
'HandleVisibility','Callback',...
'Tag','figure1',...
'UserData',[],...
'Visible','on',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );
%'Colormap',[0 0 0.5625;0 0 0.625;0 0 0.6875;0 0 0.75;0 0 0.8125;0 0 0.875;0 0 0.9375;0 0 1;0 0.0625 1;0 0.125 1;0 0.1875 1;0 0.25 1;0 0.3125 1;0 0.375 1;0 0.4375 1;0 0.5 1;0 0.5625 1;0 0.625 1;0 0.6875 1;0 0.75 1;0 0.8125 1;0 0.875 1;0 0.9375 1;0 1 1;0.0625 1 1;0.125 1 0.9375;0.1875 1 0.875;0.25 1 0.8125;0.3125 1 0.75;0.375 1 0.6875;0.4375 1 0.625;0.5 1 0.5625;0.5625 1 0.5;0.625 1 0.4375;0.6875 1 0.375;0.75 1 0.3125;0.8125 1 0.25;0.875 1 0.1875;0.9375 1 0.125;1 1 0.0625;1 1 0;1 0.9375 0;1 0.875 0;1 0.8125 0;1 0.75 0;1 0.6875 0;1 0.625 0;1 0.5625 0;1 0.5 0;1 0.4375 0;1 0.375 0;1 0.3125 0;1 0.25 0;1 0.1875 0;1 0.125 0;1 0.0625 0;1 0 0;0.9375 0 0;0.875 0 0;0.8125 0 0;0.75 0 0;0.6875 0 0;0.625 0 0;0.5625 0 0],...



appdata = [];
appdata.lastValidTag = 'uipanel1';

h2 = uipanel(...
'Parent',h1,...
'Title','Input Image',...
'Tag','uipanel1',...
'UserData',[],...
'Clipping','on',...
'Position',[0.0327868852459016 0.576 0.298155737704918 0.397333333333333],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

appdata = [];
appdata.lastValidTag = 'inputaxis';

h3 = axes(...
'Parent',h2,...
'Position',[0.0377766847024102 0.046875 0.937694704049844 0.93359375],...
'Box','on',...
'CameraPosition',[14.5 14.5 9.16025403784439],...
'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
'Color',get(0,'defaultaxesColor'),...
'ColorOrder',get(0,'defaultaxesColorOrder'),...
'LooseInset',[0.167653644541278 0.134892101824865 0.122516124857087 0.0919718876078624],...
'XColor',get(0,'defaultaxesXColor'),...
'XLim',[1 28],...
'XLimMode','manual',...
'XTick',[],...
'XTickMode','manual',...
'YColor',get(0,'defaultaxesYColor'),...
'YLim',[1 28],...
'YLimMode','manual',...
'YTick',[],...
'YTickMode','manual',...
'ZColor',get(0,'defaultaxesZColor'),...
'ButtonDownFcn',@(hObject,eventdata)DigitDemo('inputaxis_ButtonDownFcn',hObject,eventdata,guidata(hObject)),...
'Tag','inputaxis',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

h4 = get(h3,'title');

set(h4,...
'Parent',h3,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[14.5 28.6795302013423 1.00005459937205],...
'Rotation',0,...
'String',blanks(0),...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey',blanks(0),...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag',blanks(0),...
'UserData',[],...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h5 = get(h3,'xlabel');

set(h5,...
'Parent',h3,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[14.4158878504673 0.229865771812083 1.00005459937205],...
'Rotation',0,...
'String',blanks(0),...
'Interpreter','tex',...
'VerticalAlignment','cap',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey',blanks(0),...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag',blanks(0),...
'UserData',[],...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h6 = get(h3,'ylabel');

set(h6,...
'Parent',h3,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[0.453271028037382 14.3640939597315 1.00005459937205],...
'Rotation',90,...
'String',blanks(0),...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey',blanks(0),...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag',blanks(0),...
'UserData',[],...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h7 = get(h3,'zlabel');

set(h7,...
'Parent',h3,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','right',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[-3.5 31.8506711409396 1.00005459937205],...
'Rotation',0,...
'String',blanks(0),...
'Interpreter','tex',...
'VerticalAlignment','middle',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey',blanks(0),...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag',blanks(0),...
'UserData',[],...
'Visible','off',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

appdata = [];
appdata.lastValidTag = 'brushbuttongroup';

h8 = uibuttongroup(...
'Parent',h1,...
'Units','characters',...
'Title','Input Tool',...
'Tag','brushbuttongroup',...
'Clipping','on',...
'Position',[11 27.7857142857143 49 4.28571428571429],...
'SelectedObject',[],...
'SelectionChangeFcn',@(hObject,eventdata)DigitDemo('inputbutton_Callback',hObject,eventdata,guidata(hObject)),...
'OldSelectedObject',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );
%'Position',[11 29.7857142857143 49 4.28571428571429],...


appdata = [];
appdata.lastValidTag = 'pencilbutton';

h9 = uicontrol(...
'Parent',h8,...
'Units','characters',...
'Position',[2.83333333333333 1.21428571428571 13.3333333333333 1.21428571428571],...
'String','Pencil',...
'Style','radiobutton',...
'Value',1,...
'Tag','pencilbutton',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

appdata = [];
appdata.lastValidTag = 'brushbutton';

h10 = uicontrol(...
'Parent',h8,...
'Units','characters',...
'Position',[13.5 1.21428571428571 13.3333333333333 1.21428571428571],...
'String','Brush',...
'Style','radiobutton',...
'Tag','brushbutton',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

appdata = [];
appdata.lastValidTag = 'eraserbutton';

h11 = uicontrol(...
'Parent',h8,...
'Units','characters',...
'Position',[36.1666666666667 1.21428571428571 11.6666666666667 1.21428571428571],...
'String','Eraser',...
'Style','radiobutton',...
'Tag','eraserbutton',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

appdata = [];
appdata.lastValidTag = 'noisebutton';

h12 = uicontrol(...
'Parent',h8,...
'Units','characters',...
'Position',[24.8333333333333 1.21428571428571 11.6666666666667 1.21428571428571],...
'String','Noise',...
'Style','radiobutton',...
'Tag','noisebutton',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

appdata = [];
appdata.lastValidTag = 'uipanel4';

h13 = uipanel(...
'Parent',h1,...
'Title','Mean-Field Reconstruction',...
'Tag','uipanel4',...
'UserData',[],...
'Clipping','on',...
'Position',[0.348360655737705 0.577333333333333 0.296106557377049 0.390666666666667],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

appdata = [];
appdata.lastValidTag = 'meanfieldaxis';

h14 = axes(...
'Parent',h13,...
'Position',[0.0342679127725857 0.0390625 0.937694704049844 0.93359375],...
'Box','on',...
'CameraPosition',[14.5 14.5 9.16025403784439],...
'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
'Color',get(0,'defaultaxesColor'),...
'ColorOrder',get(0,'defaultaxesColorOrder'),...
'LooseInset',[0.167653644541278 0.134892101824865 0.122516124857087 0.0919718876078626],...
'XColor',get(0,'defaultaxesXColor'),...
'XLim',[1 28],...
'XLimMode','manual',...
'XTick',[],...
'XTickMode','manual',...
'YColor',get(0,'defaultaxesYColor'),...
'YLim',[1 28],...
'YLimMode','manual',...
'YTick',[],...
'YTickMode','manual',...
'ZColor',get(0,'defaultaxesZColor'),...
'ButtonDownFcn',@(hObject,eventdata)DigitDemo('meanfieldaxis_ButtonDownFcn',hObject,eventdata,guidata(hObject)),...
'Tag','meanfieldaxis',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

h15 = get(h14,'title');

set(h15,...
'Parent',h14,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[14.4575471698113 28.6911262798635 1.00005459937205],...
'Rotation',0,...
'String',blanks(0),...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey',blanks(0),...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag',blanks(0),...
'UserData',[],...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h16 = get(h14,'xlabel');

set(h16,...
'Parent',h14,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[14.4575471698113 0.216723549488055 1.00005459937205],...
'Rotation',0,...
'String',blanks(0),...
'Interpreter','tex',...
'VerticalAlignment','cap',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey',blanks(0),...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag',blanks(0),...
'UserData',[],...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h17 = get(h14,'ylabel');

set(h17,...
'Parent',h14,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[0.448113207547166 14.4078498293515 1.00005459937205],...
'Rotation',90,...
'String',blanks(0),...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey',blanks(0),...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag',blanks(0),...
'UserData',[],...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h18 = get(h14,'zlabel');

set(h18,...
'Parent',h14,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','right',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[-34.5330188679245 32.561433447099 1.00005459937205],...
'Rotation',0,...
'String',blanks(0),...
'Interpreter','tex',...
'VerticalAlignment','middle',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey',blanks(0),...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag',blanks(0),...
'UserData',[],...
'Visible','off',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

appdata = [];
appdata.lastValidTag = 'uipanel10';

h19 = uipanel(...
'Parent',h1,...
'Title','Classification',...
'Tag','uipanel10',...
'UserData',[],...
'Clipping','on',...
'Position',[0.670081967213115 0.577333333333333 0.296106557377049 0.389333333333333],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

appdata = [];
appdata.lastValidTag = 'classaxis';

h20 = axes(...
'Parent',h19,...
'Position',[0.0842105263157895 0.101818181818182 0.887719298245614 0.872727272727273],...
'Box','on',...
'CameraPosition',[14.5 14.5 9.16025403784439],...
'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
'Color',get(0,'defaultaxesColor'),...
'ColorOrder',get(0,'defaultaxesColorOrder'),...
'LooseInset',[0.176716003705671 0.144367993275372 0.129138618092606 0.0984327226877538],...
'XColor',get(0,'defaultaxesXColor'),...
'XLim',[1 28],...
'XLimMode','manual',...
'XTick',[],...
'XTickMode','manual',...
'YColor',get(0,'defaultaxesYColor'),...
'YLim',[1 28],...
'YLimMode','manual',...
'YTick',[],...
'YTickMode','manual',...
'ZColor',get(0,'defaultaxesZColor'),...
'Tag','classaxis',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

h21 = get(h20,'title');

set(h21,...
'Parent',h20,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[14.5 28.7417582417582 1.00005459937205],...
'Rotation',0,...
'String',blanks(0),...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey',blanks(0),...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag',blanks(0),...
'UserData',[],...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h22 = get(h20,'xlabel');

set(h22,...
'Parent',h20,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[14.4102990033223 0.159340659340657 1.00005459937205],...
'Rotation',0,...
'String',blanks(0),...
'Interpreter','tex',...
'VerticalAlignment','cap',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey',blanks(0),...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag',blanks(0),...
'UserData',[],...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h23 = get(h20,'ylabel');

set(h23,...
'Parent',h20,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[0.416943521594675 14.4010989010989 1.00005459937205],...
'Rotation',90,...
'String',blanks(0),...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey',blanks(0),...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag',blanks(0),...
'UserData',[],...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h24 = get(h20,'zlabel');

set(h24,...
'Parent',h20,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','right',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[-71.6129568106312 32.8956043956044 1.00005459937205],...
'Rotation',0,...
'String',blanks(0),...
'Interpreter','tex',...
'VerticalAlignment','middle',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey',blanks(0),...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag',blanks(0),...
'UserData',[],...
'Visible','off',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

appdata = [];
appdata.lastValidTag = 'uipanel11';

h25 = uipanel(...
'Parent',h1,...
'Title','Top Filters',...
'Tag','uipanel11',...
'UserData',[],...
'Clipping','on',...
'Position',[0.347336065573771 0.032 0.626024590163934 0.530666666666667],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

appdata = [];
appdata.lastValidTag = 'filteraxis';

h26 = axes(...
'Parent',h25,...
'Position',[0.0342679127725857 0.0390625 0.937694704049844 0.93359375],...
'Box','on',...
'CameraPosition',[14.5 14.5 9.16025403784439],...
'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
'Color',get(0,'defaultaxesColor'),...
'ColorOrder',get(0,'defaultaxesColorOrder'),...
'LooseInset',[0.167653644541277 0.134892101824865 0.122516124857087 0.0919718876078625],...
'XColor',get(0,'defaultaxesXColor'),...
'XLim',[1 28],...
'XLimMode','manual',...
'XTick',[],...
'XTickMode','manual',...
'YColor',get(0,'defaultaxesYColor'),...
'YLim',[1 28],...
'YLimMode','manual',...
'YTick',[],...
'YTickMode','manual',...
'ZColor',get(0,'defaultaxesZColor'),...
'Tag','filteraxis',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

h27 = get(h26,'title');

set(h27,...
'Parent',h26,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[14.4800884955752 28.5012376237624 1.00005459937205],...
'Rotation',0,...
'String',blanks(0),...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey',blanks(0),...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag',blanks(0),...
'UserData',[],...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h28 = get(h26,'xlabel');

set(h28,...
'Parent',h26,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[14.4800884955752 0.431930693069312 1.00005459937205],...
'Rotation',0,...
'String',blanks(0),...
'Interpreter','tex',...
'VerticalAlignment','cap',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey',blanks(0),...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag',blanks(0),...
'UserData',[],...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h29 = get(h26,'ylabel');

set(h29,...
'Parent',h26,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[0.741150442477878 14.3997524752475 1.00005459937205],...
'Rotation',90,...
'String',blanks(0),...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey',blanks(0),...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag',blanks(0),...
'UserData',[],...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h30 = get(h26,'zlabel');

set(h30,...
'Parent',h26,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','right',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[-16.1438053097345 54.4319306930693 1.00005459937205],...
'Rotation',0,...
'String',blanks(0),...
'Interpreter','tex',...
'VerticalAlignment','middle',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey',blanks(0),...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag',blanks(0),...
'UserData',[],...
'Visible','off',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

appdata = [];
appdata.lastValidTag = 'uipanel12';

h31 = uibuttongroup(...
'Parent',h1,...
'Units','characters',...
'Title','Inductive Principle',...
'Tag','uipanel12',...
'Clipping','on',...
'Position',[10.8333333333333 22.7142857142857 49 4.28571428571429],...
'SelectedObject',[],...
'SelectionChangeFcn',@(hObject,eventdata)DigitDemo('ipbutton_Callback',hObject,eventdata,guidata(hObject)),...
'OldSelectedObject',[],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

appdata = [];
appdata.lastValidTag = 'plbutton';

h32 = uicontrol(...
'Parent',h31,...
'Units','characters',...
'Position',[24.8333333333333 1.21428571428571 9.83333333333333 1.21428571428571],...
'String','PL',...
'Style','radiobutton',...
'Tag','plbutton',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

appdata = [];
appdata.lastValidTag = 'rmbutton';

h33 = uicontrol(...
'Parent',h31,...
'Units','characters',...
'Position',[36.1666666666667 1.21428571428571 11.6666666666667 1.21428571428571],...
'String','RM',...
'Style','radiobutton',...
'Tag','rmbutton',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

appdata = [];
appdata.lastValidTag = 'cdbutton';

h34 = uicontrol(...
'Parent',h31,...
'Units','characters',...
'Position',[13.5 1.21428571428571 10.1666666666667 1.21428571428571],...
'String','CD',...
'Style','radiobutton',...
'Tag','cdbutton',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

appdata = [];
appdata.lastValidTag = 'smlbutton';

h35 = uicontrol(...
'Parent',h31,...
'Units','characters',...
'Position',[2.83333333333333 1.21428571428571 9.5 1.21428571428571],...
'String','SML',...
'Style','radiobutton',...
'Value',1,...
'Tag','smlbutton',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

appdata = [];
appdata.lastValidTag = 'uipanel13';

h36 = uipanel(...
'Parent',h1,...
'Title','Free Energy History',...
'Tag','uipanel13',...
'UserData',[],...
'Clipping','on',...
'Position',[0.0307377049180328 0.088 0.296106557377049 0.286666666666667],...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

appdata = [];
appdata.lastValidTag = 'energyaxis';

h37 = axes(...
'Parent',h36,...
'Position',[0.133333333333333 0.101010101010101 0.83859649122807 0.873737373737374],...
'Box','on',...
'CameraPosition',[14.5 14.5 9.16025403784439],...
'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
'Color',get(0,'defaultaxesColor'),...
'ColorOrder',get(0,'defaultaxesColorOrder'),...
'LooseInset',[0.186814061060281 0.144367993275372 0.136517967697897 0.0984327226877539],...
'XColor',get(0,'defaultaxesXColor'),...
'XLim',[1 28],...
'XLimMode','manual',...
'XTick',[],...
'XTickMode','manual',...
'YColor',get(0,'defaultaxesYColor'),...
'YLim',[1 28],...
'YLimMode','manual',...
'YTick',[],...
'YTickMode','manual',...
'ZColor',get(0,'defaultaxesZColor'),...
'Tag','energyaxis',...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

h38 = get(h37,'title');

set(h38,...
'Parent',h37,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[14.4524647887324 29.0331632653061 1.00005459937205],...
'Rotation',0,...
'String',blanks(0),...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey',blanks(0),...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag',blanks(0),...
'UserData',[],...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h39 = get(h37,'xlabel');

set(h39,...
'Parent',h37,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[14.4524647887324 -0.170918367346928 1.00005459937205],...
'Rotation',0,...
'String',blanks(0),...
'Interpreter','tex',...
'VerticalAlignment','cap',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey',blanks(0),...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag',blanks(0),...
'UserData',[],...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h40 = get(h37,'ylabel');

set(h40,...
'Parent',h37,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[0.382042253521126 14.2933673469388 1.00005459937205],...
'Rotation',90,...
'String',blanks(0),...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey',blanks(0),...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag',blanks(0),...
'UserData',[],...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h41 = get(h37,'zlabel');

set(h41,...
'Parent',h37,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','right',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[-6.93838028169014 103.696428571429 1.00005459937205],...
'Rotation',0,...
'String',blanks(0),...
'Interpreter','tex',...
'VerticalAlignment','middle',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey',blanks(0),...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag',blanks(0),...
'UserData',[],...
'Visible','off',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

appdata = [];
appdata.lastValidTag = 'resetbutton';

h42 = uicontrol(...
'Parent',h1,...
'Units','characters',...
'Position',[45.3333333333333 1.85714285714286 17.3333333333333 2.92857142857143],...
'String','Reset',...
'Tag','resetbutton',...
'Callback',@(hObject,eventdata)DigitDemo('resetbutton_Callback',hObject,eventdata,guidata(hObject)),...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

appdata = [];
appdata.lastValidTag = 'samplestartbutton';

h43 = uicontrol(...
'Parent',h1,...
'Units','characters',...
'Position',[6.16666666666667 1.85714285714286 17.1666666666667 2.92857142857143],...
'String','Start Sample',...
'Tag','samplestartbutton',...
'Callback',@(hObject,eventdata)DigitDemo('samplestartbutton_Callback',hObject,eventdata,guidata(hObject)),...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );

appdata = [];
appdata.lastValidTag = 'stopsamplebutton';

h44 = uicontrol(...
'Parent',h1,...
'Units','characters',...
'Position',[25 1.85714285714286 18.6666666666667 2.92857142857143],...
'String','Stop Sample',...
'Tag','stopsamplebutton',...
'Callback',@(hObject,eventdata)DigitDemo('stopsamplebutton_Callback',hObject,eventdata,guidata(hObject)),...
'CreateFcn', {@local_CreateFcn, blanks(0), appdata} );


hsingleton = h1;


% --- Set application data first then calling the CreateFcn. 
function local_CreateFcn(hObject, eventdata, createfcn, appdata)

if ~isempty(appdata)
   names = fieldnames(appdata);
   for i=1:length(names)
       name = char(names(i));
       setappdata(hObject, name, getfield(appdata,name));
   end
end

if ~isempty(createfcn)
   if isa(createfcn,'function_handle')
       createfcn(hObject, eventdata);
   else
       eval(createfcn);
   end
end


% --- Handles default GUIDE GUI creation and callback dispatch
function varargout = gui_mainfcn(gui_State, varargin)

gui_StateFields =  {'gui_Name'
    'gui_Singleton'
    'gui_OpeningFcn'
    'gui_OutputFcn'
    'gui_LayoutFcn'
    'gui_Callback'};
gui_Mfile = '';
for i=1:length(gui_StateFields)
    if ~isfield(gui_State, gui_StateFields{i})
        error('MATLAB:gui_mainfcn:FieldNotFound', 'Could not find field %s in the gui_State struct in GUI M-file %s', gui_StateFields{i}, gui_Mfile);
    elseif isequal(gui_StateFields{i}, 'gui_Name')
        gui_Mfile = [gui_State.(gui_StateFields{i}), '.m'];
    end
end

numargin = length(varargin);

if numargin == 0
    % DIGITDEMO_EXPORT
    % create the GUI only if we are not in the process of loading it
    % already
    gui_Create = true;
elseif local_isInvokeActiveXCallback(gui_State, varargin{:})
    % DIGITDEMO_EXPORT(ACTIVEX,...)
    vin{1} = gui_State.gui_Name;
    vin{2} = [get(varargin{1}.Peer, 'Tag'), '_', varargin{end}];
    vin{3} = varargin{1};
    vin{4} = varargin{end-1};
    vin{5} = guidata(varargin{1}.Peer);
    feval(vin{:});
    return;
elseif local_isInvokeHGCallbak(gui_State, varargin{:})
    % DIGITDEMO_EXPORT(%'Callback',hObject,eventData,handles,...)
    gui_Create = false;
else
    % DIGITDEMO_EXPORT(...)
    % create the GUI and hand varargin to the openingfcn
    gui_Create = true;
end

if ~gui_Create
    % In design time, we need to mark all components possibly created in
    % the coming callback evaluation as non-serializable. This way, they
    % will not be brought into GUIDE and not be saved in the figure file
    % when running/saving the GUI from GUIDE.
    designEval = false;
    if (numargin>1 && ishghandle(varargin{2}))
        fig = varargin{2};
        while ~isempty(fig) && ~isa(handle(fig),'figure')
            fig = get(fig,'parent');
        end
        
        designEval = isappdata(0,'CreatingGUIDEFigure') || isprop(fig,'__GUIDEFigure');
    end
        
    if designEval
        beforeChildren = findall(fig);
    end
    
    % evaluate the callback now
    varargin{1} = gui_State.gui_Callback;
    if nargout
        [varargout{1:nargout}] = feval(varargin{:});
    else       
        feval(varargin{:});
    end
    
    % Set serializable of objects created in the above callback to off in
    % design time. Need to check whether figure handle is still valid in
    % case the figure is deleted during the callback dispatching.
    if designEval && ishandle(fig)
        set(setdiff(findall(fig),beforeChildren), 'Serializable','off');
    end
else
    if gui_State.gui_Singleton
        gui_SingletonOpt = 'reuse';
    else
        gui_SingletonOpt = 'new';
    end

    % Check user passing 'visible' P/V pair first so that its value can be
    % used by oepnfig to prevent flickering
    gui_Visible = 'auto';
    gui_VisibleInput = '';
    for index=1:2:length(varargin)
        if length(varargin) == index || ~ischar(varargin{index})
            break;
        end

        % Recognize 'visible' P/V pair
        len1 = min(length('visible'),length(varargin{index}));
        len2 = min(length('off'),length(varargin{index+1}));
        if ischar(varargin{index+1}) && strncmpi(varargin{index},'visible',len1) && len2 > 1
            if strncmpi(varargin{index+1},'off',len2)
                gui_Visible = 'invisible';
                gui_VisibleInput = 'off';
            elseif strncmpi(varargin{index+1},'on',len2)
                gui_Visible = 'visible';
                gui_VisibleInput = 'on';
            end
        end
    end
    
    % Open fig file with stored settings.  Note: This executes all component
    % specific CreateFunctions with an empty HANDLES structure.

    
    % Do feval on layout code in m-file if it exists
    gui_Exported = ~isempty(gui_State.gui_LayoutFcn);
    % this application data is used to indicate the running mode of a GUIDE
    % GUI to distinguish it from the design mode of the GUI in GUIDE. it is
    % only used by actxproxy at this time.   
    setappdata(0,genvarname(['OpenGuiWhenRunning_', gui_State.gui_Name]),1);
    if gui_Exported
        gui_hFigure = feval(gui_State.gui_LayoutFcn, gui_SingletonOpt);

        % make figure invisible here so that the visibility of figure is
        % consistent in OpeningFcn in the exported GUI case
        if isempty(gui_VisibleInput)
            gui_VisibleInput = get(gui_hFigure,'Visible');
        end
        set(gui_hFigure,'Visible','off')

        % openfig (called by local_openfig below) does this for guis without
        % the LayoutFcn. Be sure to do it here so guis show up on screen.
        movegui(gui_hFigure,'onscreen');
    else
        gui_hFigure = local_openfig(gui_State.gui_Name, gui_SingletonOpt, gui_Visible);
        % If the figure has InGUIInitialization it was not completely created
        % on the last pass.  Delete this handle and try again.
        if isappdata(gui_hFigure, 'InGUIInitialization')
            delete(gui_hFigure);
            gui_hFigure = local_openfig(gui_State.gui_Name, gui_SingletonOpt, gui_Visible);
        end
    end
    if isappdata(0, genvarname(['OpenGuiWhenRunning_', gui_State.gui_Name]))
        rmappdata(0,genvarname(['OpenGuiWhenRunning_', gui_State.gui_Name]));
    end

    % Set flag to indicate starting GUI initialization
    setappdata(gui_hFigure,'InGUIInitialization',1);

    % Fetch GUIDE Application options
    gui_Options = getappdata(gui_hFigure,'GUIDEOptions');
    % Singleton setting in the GUI M-file takes priority if different
    gui_Options.singleton = gui_State.gui_Singleton;

    if ~isappdata(gui_hFigure,'GUIOnScreen')
        % Adjust background color
        if gui_Options.syscolorfig
            set(gui_hFigure,'Color', get(0,'DefaultUicontrolBackgroundColor'));
        end

        % Generate HANDLES structure and store with GUIDATA. If there is
        % user set GUI data already, keep that also.
        data = guidata(gui_hFigure);
        handles = guihandles(gui_hFigure);
        if ~isempty(handles)
            if isempty(data)
                data = handles;
            else
                names = fieldnames(handles);
                for k=1:length(names)
                    data.(char(names(k)))=handles.(char(names(k)));
                end
            end
        end
        guidata(gui_hFigure, data);
    end

    % Apply input P/V pairs other than 'visible'
    for index=1:2:length(varargin)
        if length(varargin) == index || ~ischar(varargin{index})
            break;
        end

        len1 = min(length('visible'),length(varargin{index}));
        if ~strncmpi(varargin{index},'visible',len1)
            try set(gui_hFigure, varargin{index}, varargin{index+1}), catch break, end
        end
    end

    % If handle visibility is set to %'Callback', turn it on until finished
    % with OpeningFcn
    gui_HandleVisibility = get(gui_hFigure,'HandleVisibility');
    if strcmp(gui_HandleVisibility, 'Callback')
        set(gui_hFigure,'HandleVisibility', 'on');
    end

    feval(gui_State.gui_OpeningFcn, gui_hFigure, [], guidata(gui_hFigure), varargin{:});

    if isscalar(gui_hFigure) && ishandle(gui_hFigure)
        % Handle the default callbacks of predefined toolbar tools in this
        % GUI, if any
        %guidemfile('restoreToolbarToolPredefinedCallback',gui_hFigure); 
        
        % Update handle visibility
        set(gui_hFigure,'HandleVisibility', gui_HandleVisibility);

        % Call openfig again to pick up the saved visibility or apply the
        % one passed in from the P/V pairs
        if ~gui_Exported
            gui_hFigure = local_openfig(gui_State.gui_Name, 'reuse',gui_Visible);
        elseif ~isempty(gui_VisibleInput)
            set(gui_hFigure,'Visible',gui_VisibleInput);
        end
        if strcmpi(get(gui_hFigure, 'Visible'), 'on')
            figure(gui_hFigure);
            
            if gui_Options.singleton
                setappdata(gui_hFigure,'GUIOnScreen', 1);
            end
        end

        % Done with GUI initialization
        if isappdata(gui_hFigure,'InGUIInitialization')
            rmappdata(gui_hFigure,'InGUIInitialization');
        end

        % If handle visibility is set to %'Callback', turn it on until
        % finished with OutputFcn
        gui_HandleVisibility = get(gui_hFigure,'HandleVisibility');
        if strcmp(gui_HandleVisibility, 'Callback')
            set(gui_hFigure,'HandleVisibility', 'on');
        end
        gui_Handles = guidata(gui_hFigure);
    else
        gui_Handles = [];
    end

    if nargout
        [varargout{1:nargout}] = feval(gui_State.gui_OutputFcn, gui_hFigure, [], gui_Handles);
    else
        feval(gui_State.gui_OutputFcn, gui_hFigure, [], gui_Handles);
    end

    if isscalar(gui_hFigure) && ishandle(gui_hFigure)
        set(gui_hFigure,'HandleVisibility', gui_HandleVisibility);
    end
end

function gui_hFigure = local_openfig(name, singleton, visible)

% openfig with three arguments was new from R13. Try to call that first, if
% failed, try the old openfig.
if nargin('openfig') == 2
    % OPENFIG did not accept 3rd input argument until R13,
    % toggle default figure visible to prevent the figure
    % from showing up too soon.
    gui_OldDefaultVisible = get(0,'defaultFigureVisible');
    set(0,'defaultFigureVisible','off');
    gui_hFigure = openfig(name, singleton);
    set(0,'defaultFigureVisible',gui_OldDefaultVisible);
else
    gui_hFigure = openfig(name, singleton, visible);
end

function result = local_isInvokeActiveXCallback(gui_State, varargin)

try
    result = ispc && iscom(varargin{1}) ...
             && isequal(varargin{1},gcbo);
catch
    result = false;
end

function result = local_isInvokeHGCallbak(gui_State, varargin)

try
    fhandle = functions(gui_State.gui_Callback);
    result = ~isempty(findstr(gui_State.gui_Name,fhandle.file)) || ...
             (ischar(varargin{1}) ...
             && isequal(ishandle(varargin{2}), 1) ...
             && (~isempty(strfind(varargin{1},[get(varargin{2}, 'Tag'), '_'])) || ...
                ~isempty(strfind(varargin{1}, '_CreateFcn'))) );
catch
    result = false;
end


