/*
 * Copyright 2021 Marc Liberatore.
 */

package simulator;

public interface Author {
    /**
     * 
     * If you did not do all the work on this assignment yourself, 
     * document the name of everyone who worked on this assignment
     * here:
     * 
     * Person 1:
     * Person 2:
     * Etc.
     */

    /**
     * If you need to make any other notes (for example, about who did 
     * what work, or about partnerships on previous projects) do so here:
     * 
     * Notes:
     */

    /** 
     * 
     * From the syllabus:
     * 
     * Having a partner is optional for programming assignments.
     * 
     * You are free to work with different partners on each assignment. 
     * Especially for programming assignments, make sure to acknowledge 
     * any past partners whose work might have influenced your own in 
     * the Authors section.
     *
     * If you work with partner(s), you must do all the work together. 
     * It is against the rules to split up the work, or to have one 
     * person do it and another person "check" it, or to have one 
     * person write the code and another person write the tests, etc. 
     * When you submit as a partnership or group, you are asserting 
     * that all the work was done together.
     *
     * The above rule has implications for academic honesty policy 
     * violations. If one of you is guilty, all of you are guilty. 
     * Consider that carefully. If your partner went off and 
     * implemented a lot of code "on their own," how do you know they
     * wrote it? Every year, it turns out somebody actually copied the 
     * code or solution from elsewhere. You will be culpable if your 
     * partner does this, because by submitting as a partnership (or 
     * group) you are claiming the solution to be jointly written by 
     * all of you.
     *
     * Nonetheless, much like exceeding the speed limit on the highway, 
     * if you’re going to violate the rules, there are norms. On the 
     * highway, that means speeding in the left lane, and sticking to 
     * the speed limit in the right lane. In this class, we likewise 
     * know some people will violate the rules and split the work 
     * anyway. So if you do that, make sure to detail in the Author 
     * section who did what work. That is your best defense should a 
     * violation of the honesty policy be detected.
     */
}