/*
 * Copyright 2017 Marc Liberatore.
 */

package documents;

public class DocumentId {
	@Override
	public String toString() {
		return "DocumentId=" + id;
	}

	public final String id;

	public DocumentId(String id) {
		this.id = id;
	}

	@Override
	public int hashCode() {
		return id.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		DocumentId other = (DocumentId) obj;
		if (id == null) {
			if (other.id != null) {
				return false;
			}
		} else if (!id.equals(other.id)) {
			return false;
		}

		return true;
	}
}
