package data;

import java.util.Date;

/**
 * A data structure representing a URL and its last-updated state, if any..
 * 
 * Two URLRecords are considered equivalent if their hosts, ports, and paths are
 * equivalent (per equals() semantics).
 * 
 * This is a toy example. A more robust entry would likely use Java's built-in
 * java.net.URL class and the Joda-Time library; it would also have more robust
 * format checking, probably support remote error code storage, and so on.
 * 
 */
public class URLRecord {
	public final String host;
	public final int port;
	public final String path;
	private Date lastUpdated;

	/**
	 * Construct a new URLRecord
	 * @param host remote host name (cannot be null or empty)
	 * @param port remote port number (between 0 and 65535) 
	 * @param path remote host path (cannot be null)
	 */
	public URLRecord(String host, int port, String path) {
		// TODO
		this.host = null;
		this.port = -1;
		this.path = null;
	}

	/**
	 * Updates the lastUpdated field of this entry to the current date and time.
	 * 
	 * @param data
	 */
	public void update() {
		// TODO
	}

	/**
	 * 
	 * @return a copy of the Date representing the last time this URLEntry was
	 *         updated
	 */
	public Date getLastUpdated() {
		// TODO
		return null;
	}


	// TODO: add an equals() and a hashCode() method
}
