package blobcount;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Grid {
    private final int cols;
    private final Cell[] grid;
    private int blobCount = -1;

    private Grid(int cols, Cell[] grid) {
        this.cols = cols;
        this.grid = grid;
    }

    public static Grid generateRandom(int rows, int cols, double fractionFilled, long seed) {
        Cell[] grid = new Cell[rows * cols];
        Random random = new Random(seed);
        for (int i = 0; i < rows * cols; i++) {
            Cell c = new Cell(i);
            if (random.nextDouble() < fractionFilled) {
                c.setFilled(true);
            }
            grid[i] = c;
        }
        Grid g = new Grid(cols, grid);
        g.markBlobs();
        return g;
    }

    public String toString() {
        if (blobCount < 0) {
            markBlobs();
        }
        StringBuilder sb = new StringBuilder();
        int colCounter = 0;
        for (Cell cell: grid) {
            char c = cell.isFilled() ? (char)('A' + cell.getBlobId()) : '-';
            sb.append(c);
            colCounter++;
            if (colCounter % cols == 0) {
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    private void markBlobs() {
        if (blobCount >= 0) {
            return;
        }
        blobCount = 0;
        for (Cell cell: grid) {
            if (cell.isFilled() && !cell.isVisited()) {
                visit(cell);
                blobCount++;
            }
        }
    }

    private void visit(Cell cell) {
        cell.setBlobId(blobCount);
        for (Cell neighbor : neighbors(cell)) {
            if (neighbor.isFilled() && !neighbor.isVisited()) {
                visit(neighbor);
            }
        }
    }

    private List<Cell> neighbors(Cell cell) {
        List<Cell> neighbors = new ArrayList<Cell>();
        final int id = cell.getNumber();
        for (int i : new int[] {id + cols, id - cols, id + 1, id - 1}) {
            if (i >= 0 && i < grid.length) {
                neighbors.add(grid[i]);
            }
        }
        return neighbors;
    }

    public static void main(String[] args) {
        Grid g = generateRandom(10, 30, 0.4, 0);
        System.out.print(g);
        System.out.println("There are " + g.blobCount + " blobs.");
    }
}
