/* -*- C++ -*- */

/**
 * @brief C wrappers for managing timer objects.
 * @author Emery Berger <http://www.cs.umass.edu/~emery>
 */

#include "timer.h"


extern "C" void createTimer (void ** timerObject) {
  *((HL::Timer **) timerObject) = new HL::Timer;
}

extern "C" void destroyTimer (void ** timerObject) {
  delete (*((HL::Timer **) timerObject));
}

extern "C" void startTimer (void ** timerObject) {
  (*((HL::Timer **) timerObject))->start();
}

extern "C" void stopTimer (void ** timerObject) {
  (*((HL::Timer **) timerObject))->stop();
}

extern "C" double getTime (void ** timerObject) {
  return (double) (**((HL::Timer **) timerObject));
}
