/* -*- C++ -*- */

#ifndef _XALLOCHEAP_H_
#define _XALLOCHEAP_H_


template <int ArenaSize, class SuperHeap>
class XallocHeap : public SuperHeap {

public:

  inline XallocHeap (void) {
    start_of_array = (char *) SuperHeap::malloc (ArenaSize);
    end_of_array = start_of_array + align(sizeof(Nuggie)); // ((sizeof(Nuggie) + sizeof(double)-1) & ~(sizeof(double) - 1));
    size_lval(end_of_array) = 0;
    last_block = NULL;
  }

  inline ~XallocHeap (void) {
    SuperHeap::free (start_of_array);
  }

  inline void * malloc (size_t size) {
    char * old_end_of_array = end_of_array;
    end_of_array += align(size + sizeof(Nuggie)); // ((size+sizeof(Nuggie)) + sizeof(double)-1) & ~(sizeof(double) - 1);
    if (old_end_of_array + size >= start_of_array + ArenaSize) {
      // We're out of memory.
      return NULL;
    }
    size_lval(end_of_array) = end_of_array - old_end_of_array;
    clear_use(end_of_array);  /* this is not necessary, cause it will be zero */
    set_use(old_end_of_array);
    last_block = old_end_of_array;
    return old_end_of_array;
  }

  inline void free (void * ptr) {
    char * p = (char *) ptr;
    char * q;
    /* At this point we could check that the in_use bit for this block
       is set, and also check that the size is right */
    clear_use(p);  /* mark this block as unused */
    if (p == last_block) {
	while (1) {
	    q = prev_block(p);
	    if (q == p) {
		last_block = NULL;
		end_of_array = p;
		break;  /* only happens when we get to the beginning */
	    }
	    if (in_use(q)) {
		last_block = q;
		end_of_array = p;
		break;
	    }
	    p = q;
	}
    }
  }

private:

  static inline size_t& size_lval (char * x) {
    return (((Nuggie *)(((char *)x) - sizeof(Nuggie)))->size);
  }

  static inline char * prev_block (char * x) {
    return (((char *) x) - (size_lval(x) & (~1)));
  }

  static inline int in_use (char * x) {
    return (size_lval(x) & (1));
  }

  static inline void set_use (char * x) {
    (size_lval(x) |= (1));
  }

  static inline void clear_use (char * x) {
    (size_lval(x) &= (~1));
  }

  class Nuggie {
  public:
    size_t size;
  };

  inline static size_t align (int sz) {
    return (sz + (sizeof(double) - 1)) & ~(sizeof(double) - 1);
  }

  char * end_of_array;
  char * start_of_array;
  char * last_block;
};

#endif
