my %mallocs;
my $numberOfObjects = 0;
my $totalObjectSize = 0;
my $maxInUse = 0;
my $inUse = 0;
my $bogusFrees = 0;
my $totalMemOps = 0;

while (<>) {
  chop;
  $x = $_;
  if ($x =~ /M\s(.+)\s(0x.+)/) {
    # malloc
    $totalMemOps++;
    my $size = $1;
    my $addr = $2;
    $mallocs{$addr} = $size;
    $numberOfObjects++;
    $inUse += $size;
    if ($inUse > $maxInUse) {
      $maxInUse = $inUse;
    }
    $totalObjectSize += $size;
  }
  if ($x =~ /F\s(0x.+)/) {
    # free
    $totalMemOps++;
    my $addr = $1;
    if (!defined $mallocs{$addr}) {
      $bogusFrees++;
    }
    my $size = $mallocs{$addr};
    undef $mallocs{$addr};
    $inUse -= $size;
  }
}

my $averageSize = $totalObjectSize / $numberOfObjects;

print<<"EOT";
number of objects = $numberOfObjects
total object size = $totalObjectSize
average obj size  = $averageSize
max in use        = $maxInUse
still in use      = $inUse
bogus frees       = $bogusFrees
total mem ops     = $totalMemOps
EOT

