/* -*- C++ -*- */

#ifndef _SpinLock_H_
#define _SpinLock_H_

#if defined(WIN32)

#include <winbase.h>
#include <windows.h>

class SpinLockType {
public:

   SpinLockType (void)
	{
		mutex = UNLOCKED;
	}

	~SpinLockType (void)
	{
	}

	void lock (void) {
		// A yielding lock (with an initial spin).
		int i;
		for (;;) {
			i = 0;
			while (i < SPIN_LIMIT) {
				if (InterlockedExchange (&mutex, LOCKED) == UNLOCKED) {
					// We got the lock.
					return;
				}
				i++;
			}
			// Yield to other threads.
			Sleep (0);
		 }
	}

	void unlock (void) {
	    InterlockedExchange (&mutex, UNLOCKED);
	}


private:

  enum { UNLOCKED = 0, LOCKED = 1 };

  // If one cpu, spin limit should be 0. FIX ME!!
  enum { SPIN_LIMIT = 100 };

  long mutex;
};

#endif

#endif
