/* -*- C++ -*- */

#ifndef _SIZEOWNERHEAP_H_
#define _SIZEOWNERHEAP_H_

#include <assert.h>

#include "addheap.h"

/**
 * @class SizeOwnerHeap
 * @brief Adds object size and owner heap information.
 */

template <class Heap>
class SizeOwner {
public:
  union {
    struct {
      size_t size;
      Heap * owner;
    } s;
    double dummy;
  };
};

template <class Super>
class SizeOwnerHeap : public AddHeap<SizeOwner<Super>, Super> {
private:

  typedef AddHeap<SizeOwner<Super>, Super> SuperHeap;

public:
  
  inline void * malloc (size_t sz) {
    void * ptr = SuperHeap::malloc (sz);
    // Store the requested size.
    SizeOwner<Super> * so = (SizeOwner<Super> *) ptr;
    so->s.size = sz;
    so->s.owner = this;
    // Store the owner.
    return (void *) (so + 1);
  }
  
  inline void free (void * ptr) {
    void * origPtr = (void *) ((SizeOwner<Super> *) ptr - 1);
    SuperHeap::free (origPtr);
  }

  static inline Super * owner (void * ptr) {
    SizeOwner<Super> * so = (SizeOwner<Super> *) ptr - 1;
    return so->s.owner;
  }

  static inline size_t size (void * ptr) {
    SizeOwner<Super> * so = (SizeOwner<Super> *) ptr - 1;
    return so->s.size;
  }
};

#endif
