#ifndef _ONEHEAP_H_
#define _ONEHEAP_H_

//
// Wrap a single instance of a heap.
//

template <class SuperHeap>
class OneHeap {
public:
  inline void * malloc (const size_t sz) {
    return getHeap()->malloc (sz);
  }
  inline void free (void * ptr) {
    getHeap()->free (ptr);
  }
  inline int remove (void * ptr) {
    return getHeap()->remove (ptr);
  }
  inline void clear (void) {
	  getHeap()->clear();
  }
  inline size_t getSize (const void * ptr) {
	  return getHeap()->getSize (ptr);
  }
private:
 inline static SuperHeap * getHeap (void) {
	static SuperHeap theHeap;
	return &theHeap;
 }
//	SuperHeap theHeap;
};


#endif
