#include "heaplayers.h"
#include "obstackheap.h"
#include "dlheap.h"

class ObstackType : public ObstackHeap<4096 - 8, mallocHeap> {};

// class ObstackType : public Obstack<4096 - 8, UniqueHeap< KingsleyHeap<mallocHeap, MallocHeapManagerWrapper> > > {};
//class ObstackType : public Obstack<4096 - 8, UniqueHeap< DLHeap > >{};

// The C version of the above (just large enough to hold all of the data structures).
struct obstack {
  char obstackbuf[sizeof(ObstackType)];
  double dummy;
};



extern "C" void obstack_init (struct obstack *obstack)
{
	new ((void *) obstack) ObstackType();
}


extern "C" void * obstack_alloc (struct obstack *obstack, size_t size)
{
	ObstackType * ob = (ObstackType *) obstack;
	void * ptr = ob->malloc (size);
	return ptr;
}


extern "C" void * obstack_copy (struct obstack *obstack, void *address, size_t size)
{
	ObstackType * ob = (ObstackType *) obstack;
	void * ptr = ob->grow (size);
	if (ptr != NULL) {
		memcpy (ptr, address, size);
	}
	ob->finalize();
	return ptr;
}


extern "C" void * obstack_copy0 (struct obstack *obstack, void *address, size_t size)
{
	ObstackType * ob = (ObstackType *) obstack;
	void * ptr = ob->grow (size + 1);
	if (ptr != NULL) {
		memcpy (ptr, address, size);
		*((char *) ptr + size) = '\0';
	}
	ob->finalize();
	return ptr;
}


extern "C" void obstack_free (struct obstack *obstack, void *block)
{
	ObstackType * ob = (ObstackType *) obstack;
	ob->free (block);
}


extern "C" void obstack_blank (struct obstack *obstack, size_t size)
{
	ObstackType * ob = (ObstackType *) obstack;
	ob->grow (size);
}


extern "C" void obstack_grow (struct obstack *obstack, void *data, size_t size)
{
	ObstackType * ob = (ObstackType *) obstack;
	void * ptr = ob->grow (size);
	if (ptr != NULL) {
		memcpy (ptr, data, size);
	}
}


extern "C" void obstack_grow0 (struct obstack *obstack, void *data, int size)
{
	ObstackType * ob = (ObstackType *) obstack;
	void * ptr = ob->grow (size + 1);
	if (ptr != NULL) {
		memcpy (ptr, data, size);
		*((char *) ptr + size) = '\0';
	}
}


extern "C" void obstack_1grow (struct obstack *obstack, long c)
{
	ObstackType * ob = (ObstackType *) obstack;
	long * ptr = (long *) ob->grow (sizeof(long));
	*ptr = c;
}


extern "C" void obstack_ptr_grow (struct obstack *obstack, void *data)
{
	ObstackType * ob = (ObstackType *) obstack;
	void ** ptr = (void **) ob->grow (sizeof(void *));
	*ptr = data;
}


#if 0
extern "C" void obstack_int_grow (struct obstack *obstack, int data)
{
	ObstackType * ob = (ObstackType *) obstack;
	int * ptr = (char *) ob->grow (sizeof(int));
	*ptr = data;
}
#endif


extern "C" void * obstack_finish (struct obstack * obstack)
{
	ObstackType * ob = (ObstackType *) obstack;
	void * ptr = ob->getObjectBase();
	ob->finalize();
	return ptr;
}


extern "C" void * obstack_base (struct obstack *obstack)
{
	ObstackType * ob = (ObstackType *) obstack;
	return ob->getObjectBase();
}


extern "C" void * obstack_next_free (struct obstack *obstack)
{
	ObstackType * ob = (ObstackType *) obstack;
	return ob->grow(0);
}


extern "C" int _obstack_get_alignment (struct obstack *)
{
  // Double alignment.
  return sizeof(double) - 1;
}
