/* -*- C++ -*- */

#ifndef _COALESCEHEAP_H_
#define _COALESCEHEAP_H_

#include <assert.h>

#include "heaplayers.h"

/**
 * @class CoalesceHeap
 * @brief Applies splitting and coalescing.
 * @see CoalesceableHeap
 * @see RequireCoalesceable
 */

template <class SuperHeap>
class CoalesceHeap : public SuperHeap {
public:

  inline void * malloc (const size_t sz)
  {
    void * ptr = SuperHeap::malloc (sz);
    if (ptr != NULL) {
      //		const size_t actualSize = getSize(ptr);
      //		printf ("markInUse\n");
      //			printf ("S\n");
      markInUse (ptr); // , actualSize);
      void * splitPiece = split (ptr, sz);
      if (splitPiece != NULL) {
	//			printf ("split: %d\n", getSize(splitPiece));
	//			printf ("split %d into %d and %d\n", oldSize, getSize(ptr), getSize(splitPiece));
	markFree (splitPiece);
	SuperHeap::free (splitPiece);
      }
    }
    return ptr;
  }


  inline void free (void * ptr)
  {
    // Try to coalesce this object with its predecessor & successor.
    if ((getNext(getPrev(ptr)) != ptr) || (getPrev(getNext(ptr)) != ptr)) {
#if 0
      fprintf(stderr, "ptr = %x, getNext(ptr) = %x, getPrev(ptr) = %x, getPrev(getNext(ptr)) = %x, getNext(getPrev(ptr)) = %x\n",
	      ptr, getNext(ptr), getPrev(ptr), getPrev(getNext(ptr)), getNext(getPrev(ptr)));
#endif

      //	markFree (ptr);
      // We're done with this object.
      SuperHeap::free (ptr);
      return;
    }
    assert (getPrev(getNext(ptr)) == ptr);
    //	int thisHeap = getHeap(ptr);
    // Try to coalesce with the previous object..
    void * prev = getPrev(ptr);
    void * next = getNext (ptr);
    assert (prev != ptr);

    if (isPrevFree(ptr)) {
      //	  if (getHeap(prev) == thisHeap) {
      assert (isFree(prev));
      // size_t sz = getSize(prev);
      SuperHeap::remove (prev);
      coalesce (prev, ptr);
      //		printf ("coalesce: %x (%d) and %x to %x (%d)\n", prev, sz, ptr, prev, getSize(prev));
      ptr = prev;
      //	  }
    }
    // this seems unnecessary:	setPrevHeap (next, thisHeap);
    //	if (getHeap(next) == thisHeap) {
    if (isFree(next)) {
      // size_t sz = getSize(next);
      // int fr = isFree(next);
      SuperHeap::remove (next);
      coalesce (ptr, next);
      //			    printf ("coalesce: %x and %x (%d) to %d\n", ptr, next, sz, getSize(ptr));
    }
	
    markFree (ptr);

    // We're done with this object.
    SuperHeap::free (ptr);
  }

private:


  // Combine the first object with the second.
  inline static void coalesce (void * first, const void * second) {
    // A few sanity checks first.
    //	  assert (isFree(first));
    //	  assert (isFree(second));
    //    Header::getHeader(first)->sanityCheck();
    //    Header::getHeader(second)->sanityCheck();
    assert (getNext(first) == second);
    assert (getPrev(second) == first);
    //	int s = getHeap(second);
    //	int f = getHeap(first);
    //	int fn = getPrevHeap(second);
    //	assert (s == f);
    //    assert (getHeap(second) == getHeap(first));
    //    size_t secondSize = getSize(second);
    // Now coalesce.
    size_t newSize = ((size_t) second - (size_t) first) + getSize(second);
    setSize (first, newSize);
    //    assert (getPrevSize(getNext(first)) == secondSize);
    setPrevSize (getNext(first), newSize);
    //    Header::getHeader(first)->sanityCheck();
  }

  // Split an object if it is big enough.
  inline static void * split (void * obj, const size_t requestedSize) {
    // A few sanity checks first.
    //    Header::getHeader(obj)->sanityCheck();
    assert (getSize(obj) >= requestedSize);
    // We split aggressively (for now; this could be a parameter -- FIX ME).
    // printf ("split\n");
    const size_t actualSize = getSize(obj);
    if (actualSize - requestedSize >= sizeof(Header) + sizeof(double)) {
      //		printf ("actual = %d, requested = %d\n", actualSize, requestedSize);
      // Split the object.
      setSize(obj, requestedSize);
      // void * splitPiece = getNext(obj);
      void * splitPiece = (char *) obj + requestedSize + sizeof(Header);
      makeObject ((void *) getHeader(splitPiece),
		  requestedSize,
		  actualSize - requestedSize - sizeof(SuperHeap::Header));
      assert (!isFree(splitPiece));
      // Now that we have a new successor (splitPiece), we need to mark obj as in use.
      //	  markInUse (obj);
      (getHeader(splitPiece))->markPrevInUse();
      //      markInUse (obj);

      //	  Header::getHeader(obj)->sanityCheck();
      //	  setHeap (splitPiece, getHeap(obj));
      //	  Header::getHeader(splitPiece)->sanityCheck();
      assert (getSize(splitPiece) >= sizeof(double));
      assert (getSize(obj) >= requestedSize);
      //	  Header::getHeader(splitPiece)->sanityCheck();
      return splitPiece;
    } else {
      return NULL;
    }
  }


};


#endif
