/* -*- C++ -*- */

#ifndef _CHUNKHEAP_H_
#define _CHUNKHEAP_H_

#include <assert.h>
#include <stdio.h> // FIX ME

/**
 * @class ChunkHeap
 * @brief Allocates memory from the superheap in chunks.
 * @param ChunkSize The minimum size for allocating memory from the superheap.
 */

template <int ChunkSize, class SuperHeap>
class ChunkHeap : public SuperHeap {
public:

  inline ChunkHeap (void)
    : buffer (NULL),
      eob (NULL),
      increment (ChunkSize)
  {}

  inline void * malloc (const size_t sz) {
    //        return SuperHeap::malloc (sz);
    void * ptr = buffer;
    buffer += sz;
    if (buffer <= eob) {
      assert (eob != NULL);
      assert ((size_t) (eob - (char *) ptr + 1) >= sz);
      return ptr;
    }
    buffer -= sz;
    size_t remaining = (size_t) (eob - buffer + 1);
    // fprintf (stderr, "remaining %d, sz = %d\n", remaining, sz);
    // Decide how much memory to waste here.
    // getMoreMemory() may throw away the current buffer.
    //return getMoreMemory(sz);
#if 1
    if (remaining < increment / 8) {
      // fprintf (stderr, "remaining %d, increment %d\n", remaining, increment);
      return getMoreMemory (sz);
    } else {
      // fprintf (stderr, "malloc %d\n", sz);
      return SuperHeap::malloc (sz);
    }
#else
    return getMoreMemory(sz);
#endif
  }

  inline void clear (void) {
        // fprintf (stderr, "clear %x\n", this);
	increment = ChunkSize;
	  buffer = NULL;
	  eob = NULL;
	  SuperHeap::clear ();
  }

  inline int remove (void *) { abort(); return 0; }
  //  inline void free (void *) { abort(); }

private:

  void * getMoreMemory (size_t sz) {
//      printf ("BUFF\n");
//    printf ("sz = %d\n", sz);
    assert (sz > 0);
    // Round sz to the next chunk size.
    //	  size_t reqSize = (((sz-1) / ChunkSize) + 1) * ChunkSize;
    size_t reqSize;
    if (sz > increment) {
      reqSize = sz;
    } else {
      reqSize = increment;
      increment *= 5;
      increment /= 4;
    }
//	printf ("reqsize = %d, increment = %d\n", reqSize, increment);
    //	  size_t reqSize = (sz + ChunkSize-1) & ~(ChunkSize-1);
    //	  printf ("reqSize = %d\n", reqSize);
    //	  size_t reqSize = sz > ChunkSize ? sz : ChunkSize;
    char * buf = (char *) SuperHeap::malloc (reqSize);
	if (buf == NULL) {
		return NULL;
	}

    if (eob != buf) {
      buffer = buf;
    } else {
//      fprintf (stderr, "doh!: %x, %x\n", eob, buf);
    }
    if (buffer == NULL) {
      eob = buffer;
	  return NULL;
    } else {
      eob = buffer + reqSize;
    }
    
    //	  remaining = reqSize;
    // fprintf (stderr, "buffer = %x, eob = %x, diff = %d, reqSize = %d\n", buffer, eob, (size_t) eob - (size_t) buffer, reqSize);
    void * ptr = buffer;
    buffer += sz;
    return ptr;
  }

  char * buffer;
  char * eob;
  size_t increment;
};

#endif
