// -*- C++ -*-

#ifndef _BITSTRING_H_
#define _BITSTRING_H_

#include <assert.h>

template <int N>
class BitString {
public:

  BitString (void) {
    clear();
  }

  inline void clear (void) {
    for (int i = 0; i < NUM_ULONGS; i++) {
      B[i] = 0;
    }
  }
    
#if 0
  inline int first (void) const {
    for (int i = 0; i < NUM_ULONGS; i++) {
      if (B[i] > 0) {
	unsigned long index = 1U << (BITS_PER_ULONG-1);
	for (int j = 0; j < BITS_PER_ULONG; j++) {
	  if (B[i] & index) {
	    return j + i * BITS_PER_ULONG;
	  }
	  index >>= 1;
	}
      }
    }
    return -1;
  }
#endif

  inline int firstAfter (const int index) const {
#if 0
	for (int i = index; i < N; i++ ) {
        int ind = i >> SHIFTS_PER_ULONG;
		if (B[ind] & (1U << (i & 31))) {
			return i;
		}
	}
	return -1;
#else
	int indmask = index - (index >> 5) * 32;
	for (int i = index >> 5; i < NUM_ULONGS; i++) {
      if (B[i]) {
		unsigned long bitval = B[i];
		bitval &= ~((1 << (indmask & 31)) - 1);
		if (bitval) {
		  return (i * BITS_PER_ULONG + lsb(bitval));
		}
      }
	  indmask = indmask - 32;
	  if (indmask < 0) {
		  indmask = 0;
	  }
    }
    return -1;
#endif
  }

  inline bool get (const int index) const {
    assert (index >= 0);
    assert (index < N);
    int ind = index >> SHIFTS_PER_ULONG;
    assert (ind >= 0);
    assert (ind < NUM_ULONGS);
    return (B[ind] & (1U << (index & 31)));
  }

  inline void set (const int index) {
    assert (index >= 0);
    assert (index < N);
    int ind = index >> SHIFTS_PER_ULONG;
    assert (ind >= 0);
    assert (ind < NUM_ULONGS);
    B[ind] |= (1U << (index & 31));
  }

  inline void reset (const int index) {
    assert (index >= 0);
    assert (index < N);
    int ind = index >> SHIFTS_PER_ULONG;
    assert (ind >= 0);
    assert (ind < NUM_ULONGS);
    B[ind] &= ~(1U << (index & 31));
  }

  unsigned long operator() (int index) {
    assert (index >= 0);
    assert (index < NUM_ULONGS);
    return B[index];
  }


private:

  enum { BITS_PER_ULONG = 32 };
  enum { SHIFTS_PER_ULONG = 5 };

  enum { MAX_BITS = (N + BITS_PER_ULONG - 1) & ~(BITS_PER_ULONG - 1) };
  enum { NUM_ULONGS = MAX_BITS / BITS_PER_ULONG };

  unsigned long B[NUM_ULONGS];

  inline static int lsb (unsigned long b) {
    static const int index32[32] = { 0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9 };
    const unsigned long debruijn32 = 0x077CB531UL;
    b &= (unsigned long) -((signed long) b);
    b *= debruijn32;
    b >>= 27;
    assert (b >= 0);
    assert (b < 32);
    return index32[b];
  }

};


#endif
