// -*- C++ -*-

#ifndef _ADAPT_H_
#define _ADAPT_H_

/**
 * @class AdaptHeap
 * @brief Maintains dictionary entries through freed objects.
 * Sample dictionaries include DLList and SLList.
 */

template <class Dictionary, class SuperHeap>
class AdaptHeap : public SuperHeap {
public:

  ~AdaptHeap (void) {
#if 0
	  // Disabled for now.
	  Entry * ptr;
    while ((ptr = (Entry *) dict.get()) != NULL) {
      SuperHeap::free (ptr);
    }
#endif
  }

  /// Allocate an object (remove from the dictionary).
  inline void * malloc (const size_t) {
    void * ptr = (Entry *) dict.get();
    return ptr;
  }

  /// Deallocate the object (return to the dictionary).
  inline void free (void * ptr) {
    Entry * entry = (Entry *) ptr;
    dict.insert (entry);
  }

  /// Remove an object from the dictionary.
  inline int remove (void * ptr) {
    dict.remove ((Entry *) ptr);
    return 1;
  }

  /// Clear the dictionary.
  inline void clear (void) {
    dict.clear();
    SuperHeap::clear();
  }


private:

  /// The dictionary object.
  Dictionary dict;

  class Entry : public Dictionary::Entry {};
};


#endif // _ADAPT_H_
