// -*- C++ -*-

/*

  StaticHeap: manage a fixed range of memory.

*/

#ifndef _STATICHEAP_H_
#define _STATICHEAP_H_

template <int MemorySize>
class StaticHeap {
public:

  StaticHeap (void)
    : ptr (&buf[0]),
    remaining (MemorySize)
  {}

  inline void * malloc (size_t sz) {
    if (remaining < sz) {
      return NULL;
    }
    void * p = ptr;
    ptr += sz;
    remaining -= sz;
    return p;
  }

  void free (void *) {}
  int remove (void *) { return 0; }

private:

  char buf[MemorySize];
  char * ptr;
  size_t remaining;
};

#endif
