#ifndef _SLOPHEAP_H_
#define _SLOPHEAP_H_

/**
 * @class SlopHeap
 * 
 * SlopHeap is designed to guarantee that you always have an extra N bytes
 * available after the most recent malloc. This is necessary for the current
 * coalescing support, which can look past the last allocated object.
 *
 * @param SuperHeap The parent heap.
 * @param SLOP The amount of extra memory required, in bytes.
 */

template <class SuperHeap, int SLOP = 16>
class SlopHeap : public SuperHeap {
public:
  SlopHeap (void)
    : remaining (0),
      ptr (NULL)
  {
    //		printf ("Woo. %x\n", this);
  }
  
  inline void * malloc (const size_t nbytes) {

  //   printf ("request %d\n", nbytes);

    // Put the usual case up front.
    
    if (nbytes <= remaining) {
//		printf ("remaining = %d\n", remaining);
      remaining -= nbytes;
      char * p = ptr;
      ptr += nbytes;
      return (void *) p;
    }
    
    //
    // We don't have enough space to satisfy the current
    // request, so get more memory.
    //

	return getMoreMemory(nbytes);
  }
  
  inline void clear (void) {
    ptr = NULL;
    remaining = 0;
    SuperHeap::clear ();
  }

  inline void free (void *) { abort(); }
  inline int remove (void *) { abort(); return 0; }

private:
  
  void * getMoreMemory (size_t nbytes) {
    //    printf ("nbytes = %d\n", nbytes + SLOP);
    char * newptr = (char *) SuperHeap::malloc (nbytes + SLOP);

//	printf ("newptr = %x\n", newptr);
#if 0
    if (newptr == NULL) {
      return NULL;
    }
#endif

	// printf ("ptr = %x, remaining = %d, all = %x, newptr = %x\n", ptr, remaining, ptr + remaining + SLOP, newptr);


    //
    // If this new memory is contiguous with the previous one,
    // reclaim the "slop".
    //
    
    if ((ptr != NULL) && (ptr + remaining + SLOP == newptr)) {
      remaining += SLOP;
      //printf ("*** slop reclaimed.\n");
    } else {
#if 0
		if (ptr != NULL)
			printf ("Couldn't reclaim slop!! -- %x, %d, %x, %x\n", ptr, remaining, ptr + remaining + SLOP, newptr);
#endif
		ptr = newptr;
		remaining = 0;
	}
//	printf ("remaining was %d, ptr was %d\n", remaining, ptr);
    char * p = ptr;
    ptr += nbytes;
//	printf ("remaining now %d, ptr now = %d\n", remaining, ptr);

    return (void *) p;
	}

  char * ptr;
  size_t remaining;
};

#endif
