// -*- C++ -*-

#ifndef _SLLIST_H_
#define _SLLIST_H_

#include <assert.h>

/**
 * @class SLList
 * @brief A "memory neutral" singly-linked list.
 * @author Emery Berger
 */

class SLList {
public:

  inline SLList (void) {
    clear();
  }

  class Entry;
  
  /// Clear the list.
  inline void clear (void) {
    head.next = &head;
  }

  /// Get the head of the list.
  inline Entry * get (void) {
	const Entry * e = head.next;
	if (e == &head) {
		return NULL;
	}
	head.next = e->next;
	return (Entry *) e;
  }

private:

  /**
   * @brief Remove one item from the list.
   * @warning This method aborts the program if called.
   */
  inline void remove (Entry *) {
    abort();
  }

public:

  /// Inserts an entry into the head of the list.
  inline void insert (Entry * e) {
    e->next = head.next;
    head.next = e;
  }

  /// An entry in the list.
  class Entry {
  public:
    inline Entry (void)
    {}
//  private:
//    Entry * prev;
  public:
    Entry * next;
  };

private:

  /// The head of the list.
  Entry head;

};

#endif
