/* -*- C++ -*- */

#ifndef _POSIXLOCK_H_
#define _POSIXLOCK_H_

#include <pthread.h>

/**
 * @class PosixLockType
 * @brief Locking using POSIX mutex objects.
 */

class PosixLockType {
public:

  PosixLockType (void)
  {
    pthread_mutex_init (&mutex, NULL);
  }
  
  ~PosixLockType (void)
  {
    pthread_mutex_destroy (&mutex);
  }
  
  void lock (void) {
    pthread_mutex_lock (&mutex);
  }
  
  void unlock (void) {
    pthread_mutex_unlock (&mutex);
  }
  
private:
  pthread_mutex_t mutex;
};

#endif
