// -*- C++ -*-

#ifndef _NESTEDHEAP_H_
#define _NESTEDHEAP_H_

/**
 * @class NestedHeap
 * @brief Hierarchical heaps.
 */

template <class SuperHeap>
class NestedHeap : public SuperHeap {
public:

  NestedHeap (void)
    : parent (NULL),
      child (NULL),
      prev (NULL),
      next (NULL)
  {
  }

  ~NestedHeap (void)
  {
    clear();
    if (parent != NULL) {
      parent->removeChild (this);
    }
    removeSibling (this);
  }

  inline void clear (void) {

    // Clear this heap.
    SuperHeap::clear();

#if 0
    //
    // Iterate through all children and delete them.
    //

    if (child != NULL) {
      NestedHeap<SuperHeap> * nextChild = child->next;
      while (child != NULL) {
	NestedHeap<SuperHeap> * prevChild = child->prev;
	delete child;
	child = prevChild;
      }
      child = nextChild;
      while (child != NULL) {
	nextChild = child->next;
	delete child;
	child = nextChild;
      }
    }
    assert (child == NULL);

#else // clear all the children.

    NestedHeap<SuperHeap> * ch = child;
    while (ch != NULL) {
      NestedHeap<SuperHeap> * nextChild = ch->next;
      ch->clear();
      ch = nextChild;
    }
#endif

  }

  void addChild (NestedHeap<SuperHeap> * ch)
  {
    if (child == NULL) {
      child = ch;
      child->prev = NULL;
      child->next = NULL;
    } else {
      assert (child->prev == NULL);
      assert (ch->next == NULL);
      ch->prev = NULL;
      ch->next = child;
      child->prev = ch;
      child = ch;
    }
    child->parent = this;
  }

private:

  void removeChild (NestedHeap<SuperHeap> * ch)
  {
    assert (ch != NULL);
    if (child == ch) {
      if (ch->prev) {
	child = ch->prev;
      } else if (ch->next) {
	child = ch->next;
      } else {
	child = NULL;
      }
    }
    removeSibling (ch);
  }

  inline static void removeSibling (NestedHeap<SuperHeap> * sib)
  {
    if (sib->prev) {
      sib->prev->next = sib->next;
    }
    if (sib->next) {
      sib->next->prev = sib->prev;
    }
  }

  NestedHeap<SuperHeap> * parent;
  NestedHeap<SuperHeap> * child;
  NestedHeap<SuperHeap> * prev;
  NestedHeap<SuperHeap> * next;

};

#endif
