/* -*- C++ -*- */

#ifndef _MALLOCHEAP_H_
#define _MALLOCHEAP_H_

#include <stdlib.h>

#ifdef WIN32
#include <malloc.h>
#endif

/**
 * @class mallocHeap
 * @brief A "source heap" that uses malloc and free.
 */

class mallocHeap {
public:

  ~mallocHeap (void) {}
  
  inline void * malloc (size_t sz) {
    return ::malloc (sz);
  }
  
  
  inline void free (void * ptr) {
    ::free (ptr);
  }

#ifdef WIN32
  inline size_t getSize (void * ptr) {
	  return ::_msize (ptr);
  }
#endif
  
};



#endif
