/* -*- C++ -*- */

#ifndef _LOCKEDHEAP_H_
#define _LOCKEDHEAP_H_

#if defined(WIN32)
#include "winlock.h"
#else
#include "posixlock.h"
#endif


template <class Super>
class LockedHeap : public Super {
public:

  LockedHeap (void)
  {}

  inline void * malloc (size_t sz) {
    Lock l (lock);
    void * ptr = Super::malloc (sz);
    return ptr;
  }
  
  inline void free (void * ptr) {
    Lock l (lock);
    Super::free (ptr);
  }
  
  inline int remove (void * ptr) {
    Lock l (lock);
    return Super::remove (ptr);
  }

#if defined(WIN32)
  typedef WinLockType LockType;
#else
  typedef PosixLockType LockType;
#endif

private:

  LockType lock;

  class Lock {
  public:
	  inline Lock (LockType& l)
		  : theLock (l)
	  {
		  theLock.lock();
	  }
	  inline ~Lock (void) {
		  theLock.unlock();
	  }
  private:
	  LockType& theLock;
  };

};

#endif
