/* -*- C++ -*- */

#ifndef _HYBRIDHEAP_H_
#define _HYBRIDHEAP_H_

#include <assert.h>

// Objects smaller than BigSize are allocated and freed to SmallHeap.
// Bigger objects are passed on to the super heap.

template <int BigSize, class SmallHeap, class SuperHeap>
class HybridHeap : public SuperHeap {
public:
	inline void * malloc (size_t sz) {
		if (sz < BigSize) {
			return sm.malloc (sz);
		} else {
			return SuperHeap::malloc (sz);
		}
	}

	inline void free (void * ptr) {
		if (getSize(ptr) < BigSize) {
			sm.free (ptr);
		} else {
			SuperHeap::free (ptr);
		}
	}

	inline void clear (void) {
		sm.clear();
		SuperHeap::clear();
	}

private:
	SmallHeap sm;
};

#if 0
#include "objectmanager.h"

template <int t1, class SmallHeap, class BigHeap, class OMWrapper>
class HybridHeap : public SelectObjectManagerHeap<EmptyHeap, OMWrapper>::TheHeap {
public:
  
  inline void * malloc (size_t sz) {
	  void * ptr;
    if (sz <= t1) {
		ptr = sm.malloc (sz);
    } else {
		ptr = bg.malloc (sz);
    }
	assert (getSize(ptr) >= sz);
	return ptr;
  }
  
  inline void free (void * ptr) {
	size_t sz = getSize(ptr);
	if (sz <= t1) {
		sm.free (ptr);
	} else {
		bg.free (ptr);
	}
  }

private:

	SelectObjectManagerHeap<SmallHeap, OMWrapper>::TheHeap sm;
	SelectObjectManagerHeap<BigHeap, OMWrapper>::TheHeap   bg;
};
#endif


#endif
