#ifndef _EXCEPTION_HEAP
#define _EXCEPTION_HEAP

#include <new>
#include <new.h>

class std::bad_alloc;

template <class Super>
class ExceptionHeap : public Super {
public:
  inline void * malloc (size_t sz) throw (std::bad_alloc) {
    void * ptr = Super::malloc (sz);
    if (ptr == NULL) {
      throw new std::bad_alloc;
    }
    return ptr;
  }
};


template <class Super>
class CatchExceptionHeap : public Super {
public:
	inline void * malloc (size_t sz) {
		void * ptr;
		try {
			ptr = Super::malloc (sz);
		} catch (std::bad_alloc) {
			ptr = NULL;
		}
		return ptr;
	}
};

#endif
