// -*- C++ -*-

#ifndef _DLLIST_H_
#define _DLLIST_H_

#include <assert.h>

/**
 *
 * @class DLList
 * @brief A "memory neutral" doubly-linked list.
 * @author Emery Berger
 */

class DLList {
public:

  inline DLList (void) {
    clear();
  }

  class Entry;
  
  /// Clear the list.
  inline void clear (void) {
    head.setPrev (&head);
    head.setNext (&head);
  }

  /// Get the head of the list.
  inline Entry * get (void) {
    const Entry * e = head.next;
    if (e == &head) {
      return NULL;
    }
    head.next = e->next;
    head.next->prev = &head;
    return (Entry *) e;
  }

  /// Remove one item from the list.
  inline void remove (Entry * e) {
    e->remove();
  }

  /// Insert an entry into the head of the list.
  inline void insert (Entry * e) {
    e->insert (&head, head.next);
  }

  /// An entry in the list.
  class Entry {
  public:
    //  private:
    inline void setPrev (Entry * p) { assert (p != NULL); prev = p; }
    inline void setNext (Entry * p) { assert (p != NULL); next = p; }
    inline Entry * getPrev (void) const { return prev; }
    inline Entry * getNext (void) const { return next; }
    inline void remove (void) const {
      prev->setNext(next);
      next->setPrev(prev);
    }
    inline void insert (Entry * p, Entry * n) {
      prev = p;
      next = n;
      p->setNext (this);
      n->setPrev (this);
    }
    Entry * prev;
    Entry * next;
  };

private:

  /// The head of the list.
  Entry head;

};

#endif
