/* -*- C++ -*- */

#ifndef _DEBUGHEAP_H_
#define _DEBUGHEAP_H_

#include <assert.h>


template <class Super>
class DebugHeap : public Super {
public:

  // Fill with A's.
  inline void * malloc (size_t sz) {
	void * ptr = Super::malloc (sz);
#ifndef NDEBUG
	if (ptr != NULL) {
		assert (getSize(ptr) >= sz);
		memset (ptr, 'A', sz);
	}
#endif
    return ptr;
  }
  
  // Fill with F's.
  inline void free (void * ptr) {
#ifndef NDEBUG
	memset (ptr, 'F', getSize(ptr));
#endif
    Super::free (ptr);
  }
};

#endif
