#include <unistd.h>
#include <sys/wait.h>
#include <stdio.h>

main() {
  int parentID = getpid(); /* ID of this process */
  char prgname[1024];
  gets(prgname); /* Read the name of the program we want to start */
  int cid = fork();
  if (cid == 0) { /* I'm the child process */
    execlp( prgname, prgname, 0); /* Load the program */
    /* If the program named prgname can be started, we never get
       to this line, because the child program is replaced by prgname */
    printf("I didn't find program %s\n", prgname);
  } else { /* I'm the parent process */
    sleep(1); /* Give my child time to start. */
    waitpid(cid, 0, 0); /* Wait for my child to terminate. */
    printf("Program %s finished\n", prgname);
  } 
}
