% This m-file implements the mixture of Gaussians algorithm for background
% subtraction.  It may be used free of charge for any purpose (commercial
% or otherwise), as long as the author (Seth Benton) is acknowledged.


clear all

% source = aviread('san_fran_traffic_30sec_QVGA');
source = aviread('..\test_video\san_fran_traffic_30sec_QVGA_Cinepak');

pixel_depth = 8;                        % 8-bit resolution
pixel_range = 2^pixel_depth -1;         % pixel range (# of possible values)

% -----------------------  frame size variables -----------------------

fr = source(1).cdata;           % read in 1st frame as background frame
fr_bw = rgb2gray(fr);     % convert background to greyscale
fr_size = size(fr);             
width = fr_size(2);
height = fr_size(1);
fg = zeros(height, width);

% --------------------- mog variables -----------------------------------

C = 3;                                  % number of gaussian components (typically 3-5)\
M = 3;                                  % number of background components
D = 2.5;                                % positive deviation threshold
alpha = 0.01;                           % learning rate (between 0 and 1)
thresh = 0.25;                          % foreground threshold (0.25 or 0.75 in paper)
sd_init = 6;                            % initial standard deviation (for new components) var = 36 in paper
w = zeros(height,width,C);              % initialize weights array
mean = zeros(height,width,C);           % pixel means
sd = zeros(height,width,C);             % pixel standard deviations
u_diff = zeros(height,width,C);         % difference of each pixel from mean
p = alpha/(1/C);                        % initial p variable (used to update mean and sd)
rank = zeros(1,C);                      % rank of components (w/sd)

% --------------------- initialize component means and weights -----------

for i=1:height
    for j=1:width
        for k=1:C
            
            mean(i,j,k) = rand*pixel_range;     % means random (0-255)
            w(i,j,k) = 1/C;                     % weights uniformly dist
            sd(i,j,k) = sd_init;                % initialize to sd_init
            
        end
    end
end


for n = 1:length(source)
    
    n
    fr = double(source(n).cdata);       % read in frame
  

    [fr_bw, fg, w, mean, sd] = mixture_of_gaussians_c(fr,mean,w,sd,alpha,sd_init,thresh,C,D,M,width,height);
    
    figure(1),subplot(1,2,1),imshow(uint8(fr_bw))
    subplot(1,2,2),imshow(uint8(fg))
    
    
end



