/**********************************************************/
/* End User Licensee may distribute C code generated from */
/* Catalytic licensed functions only in combination with  */
/* the original work of Licensee.                         */
/**********************************************************/
/******************************************************************/
/* Catalytic MCS-file info                                        */
/* ============================================================== */
/* Created  : Thu Jun 19 18:07:10 2008                            */
/* Command  : ctmcs -mex mixture_of_gaussians_c.m                 */
/* Version  : 3.2-2781 -- Mon Feb 11 16:21:00 PST 2008            */
/* MATLAB   : 7.5.0.342 (R2007b)                                  */
/* Computer : PCWIN                                               */
/******************************************************************/

#ifndef _CT_MCS_MEX
#  include "ct_target_m2c.h"
#else
#  include "ct_target_mex.h"
#endif

#include "ct_runtime.h"

#include "mixture_of_gaussians_c.h"
/* mixture_of_gaussians_c.m:1	function [fr_bw, fg, w, mean, sd] = mixture_of_gaussians_c(fr,mean,w,sd,alpha,sd_init,thresh,C,D,M,width,height) */
/*************************************************************
 *
 * FUNCTION: _mixture_of_gaussians_c
 *
 *************************************************************/

void  _mixture_of_gaussians_c(double(*(* fr_bw_out)), int32* fr_bw_out_dim1, int32* fr_bw_out_dim2, int32(*(* fg_out)), int32* fg_out_dim1, int32* fg_out_dim2, double w_3_out[3][320][240], double mean_3_out[3][320][240], double sd_3_out[3][320][240], double fr[3][320][240], double mean[3][320][240], double w[3][320][240], double sd[3][320][240], double alpha, double sd_init, double thresh, double C, double D, double M, double width, double height) {
   double *fr_bw_out_1;
   int32 *fg_out_1;
   double *u_diff;
   int32 u_diff_dim1, u_diff_dim2, u_diff_dim3;
   int32 *rank_ind;
   int32 rank_ind_dim2;
   double min_w, p, rank_temp, dtemp_0, dtemp_1;
   double (*fr_1)[3][76800];
   double (*I)[76800];
   int32 match, k, min_w_index, rank_ind_temp, itemp_0;
   double rank[3];
   static double dtemp_2[3] = 
             {
                0.2989, 0.58699999999999997, 0.114
             };
   double (*dtemp_3)[320][240];
   int32 itemp_1, itemp_2, itemp_3, itemp_4, itemp_5;
   int32 itemp_6, itemp_7, itemp_8, itemp_9, i1;
   double dtemp_4;
   int32 i2, i3, l;

   CT_INIT(fr_bw_out_1);
   CT_INIT(fg_out_1);
   CT_INIT(fr_1);
   CT_ALLOC(fr_1, 1, double (*)[3][76800]);
   CT_INIT(u_diff);
   CT_INIT(I);
   CT_ALLOC(I, 1, double (*)[76800]);
   CT_INIT(rank_ind);
   CT_INIT(dtemp_3);
   CT_ALLOC(dtemp_3, 1, double (*)[320][240]);
   for (i1=0; i1<=2; i1+=1) {
      for (i2=0; i2<=319; i2+=1) {
         for (i3=0; i3<=239; i3+=1) {
            sd_3_out[i1][i2][i3] = sd[i1][i2][i3];
            w_3_out[i1][i2][i3] = w[i1][i2][i3];
            mean_3_out[i1][i2][i3] = mean[i1][i2][i3];
         }
      }
   }
   /* mixture_of_gaussians_c.m:4	    mbreal(fr,mean,w,sd,alpha,sd_init,C,D,M,thresh,width,height); */
   /* mixture_of_gaussians_c.m:5	    mbscalar(thresh,width,height,alpha,sd_init,C,D,M); */
   /* mixture_of_gaussians_c.m:6	    mbsize([240 320 3],fr,mean,w,sd); */
   /* mixture_of_gaussians_c.m:8	    u_diff = zeros(height,width,C);         % difference of each pixel from mean */
   ct_set_max(u_diff_dim1, ((int32)height), 0);
   ct_set_max(u_diff_dim2, ((int32)width), 0);
   ct_set_max(u_diff_dim3, ((int32)C), 0);
   CT_CALLOC(u_diff,  u_diff_dim1 * u_diff_dim2 * u_diff_dim3, double *);
   /* mixture_of_gaussians_c.m:10	%     fr_bw = double(rgb2gray(fr));       % convert frame to grayscale */
   /* mixture_of_gaussians_c.m:11	    fg = zeros(height,width);  */

   ct_set_max(*fg_out_dim1, ((int32)height), 0);
   ct_set_max(*fg_out_dim2, ((int32)width), 0);
   CT_CALLOC(fg_out_1, (*fg_out_dim1) * (*fg_out_dim2), int32 *);
   /* mixture_of_gaussians_c.m:13	    origSize = size(fr); */
   /* mixture_of_gaussians_c.m:14	    sizeOutput = [origSize(1), origSize(2)]; */
   /* mixture_of_gaussians_c.m:16	    fr = reshape(fr(:),origSize(1)*origSize(2),3); */
   for (i1=0; i1<=230399; i1+=1) {
      ((double*)(*fr_1))[i1] = ((double*)fr)[i1];
   }
   /* mixture_of_gaussians_c.m:17	    coef = [.2989; .5870; .1140]; */
   /* mixture_of_gaussians_c.m:19	    I = double(fr) * coef; */
   memset((*I), 0, 614400);
   for (i1=0; i1<=2; i1+=1) {
      for (i2=0; i2<=76799; i2+=1) {
         (*I)[i2] =  (*I)[i2] +  (*fr_1)[i1][i2] *  dtemp_2[i1];
      }
   }
   /* mixture_of_gaussians_c.m:20	    fr_bw = reshape(I,sizeOutput);    */
   *fr_bw_out_dim1 = 240;
   *fr_bw_out_dim2 = 320;
   CT_ALLOC(fr_bw_out_1, 76800, double *);
   for (i1=0; i1<=76799; i1+=1) {
      fr_bw_out_1[i1] = (*I)[i1];
   }

   /* mixture_of_gaussians_c.m:22	    % calculate difference of pixel values from mean */
   /* mixture_of_gaussians_c.m:23	    for m=1:C */

   for (i1=0; i1<=(((int32)C)) - 1; i1+=1) {
      /* mixture_of_gaussians_c.m:24	        u_diff(:,:,m) = double(fr_bw) - mean(:,:,m); */
      for (i2=0; i2<=319; i2+=1) {
         for (i3=0; i3<=239; i3+=1) {
            (*dtemp_3)[i2][i3] =  fr_bw_out_1[ 240 * i2 + i3] -  mean[i1][i2][i3];
         }
      }
      ct_set_max(itemp_1, u_diff_dim1, 0);
      ct_set_max(itemp_2, u_diff_dim2, 0);
      __CT_DYN_EXT_CHK((itemp_1 != 0)&&(1 > u_diff_dim1), "mixture_of_gaussians_c.m", 24);
      __CT_DYN_EXT_CHK((itemp_2 != 0)&&(1 > u_diff_dim2), "mixture_of_gaussians_c.m", 24);
      __CT_DYN_EXT_CHK(  1 - u_diff_dim3 + i1 > 0, "mixture_of_gaussians_c.m", 24);
      __CT_ASGN_DIM_CHK((itemp_2 != 1)&&(  (itemp_2 > 1) - 2 + (itemp_1 > 1) != 0), "mixture_of_gaussians_c.m", 24);
      __CT_ASGN_CHK( itemp_1 * itemp_2 - 76800, "mixture_of_gaussians_c.m", 24);
      itemp_8 = 0;
      for (i2=0; i2<=itemp_2 - 1; i2+=1) {
         for (i3=0; i3<=itemp_1 - 1; i3+=1) {
            u_diff[   u_diff_dim2 * u_diff_dim1 * i1 + u_diff_dim1 * i2 + i3] = ((double*)(*dtemp_3))[itemp_8];
            itemp_8 = 1 + itemp_8;
         }
      }
   }

   /* mixture_of_gaussians_c.m:25	    end */
   /* mixture_of_gaussians_c.m:27	    % update gaussian components for each pixel */
   /* mixture_of_gaussians_c.m:28	    for i=1:height */

   itemp_7 = ((int32)height);
   for (i1=0; i1<=itemp_7 - 1; i1+=1) {
      /* mixture_of_gaussians_c.m:29	        for j=1:width */
      itemp_6 = ((int32)width);
      for (i2=0; i2<=itemp_6 - 1; i2+=1) {
         /* mixture_of_gaussians_c.m:31	            match = 0; */
         match = 0;
         /* mixture_of_gaussians_c.m:32	            for k=1:C            */
         for (i3=0; i3<=(((int32)C)) - 1; i3+=1) {
            /* mixture_of_gaussians_c.m:34	                if (abs(u_diff(i,j,k)) <= D*sd(i,j,k))       % pixel matches component */
            if ( fabs(u_diff[   u_diff_dim2 * u_diff_dim1 * i3 + u_diff_dim1 * i2 + i1]) <= D *  sd_3_out[i3][i2][i1]) {
               /* mixture_of_gaussians_c.m:36	                    match = 1;                          % variable to signal component match */

               match = 1;
               /* mixture_of_gaussians_c.m:38	                    % update weights, mean, sd, p */
               /* mixture_of_gaussians_c.m:39	                    w(i,j,k) = (1-alpha)*w(i,j,k) + alpha; */

               __CT_DYN_EXT_CHK(i1 > 239, "mixture_of_gaussians_c.m", 39);
               __CT_DYN_EXT_CHK(i2 > 319, "mixture_of_gaussians_c.m", 39);
               __CT_DYN_EXT_CHK(i3 > 2, "mixture_of_gaussians_c.m", 39);
               w_3_out[i3][i2][i1] =  (1.0 - alpha) *  w_3_out[i3][i2][i1] + alpha;
               /* mixture_of_gaussians_c.m:40	                    p = alpha/w(i,j,k);                   */
               p = alpha /  w_3_out[i3][i2][i1];
               /* mixture_of_gaussians_c.m:41	                    mean(i,j,k) = (1-p)*mean(i,j,k) + p*double(fr_bw(i,j)); */
               __CT_DYN_EXT_CHK(i1 > 239, "mixture_of_gaussians_c.m", 41);
               __CT_DYN_EXT_CHK(i2 > 319, "mixture_of_gaussians_c.m", 41);
               __CT_DYN_EXT_CHK(i3 > 2, "mixture_of_gaussians_c.m", 41);
               mean_3_out[i3][i2][i1] =  (1.0 - p) *  mean_3_out[i3][i2][i1] + p *  fr_bw_out_1[i1 + 240 * i2];
               /* mixture_of_gaussians_c.m:42	                    sd(i,j,k) =   sqrt((1-p)*(sd(i,j,k)^2) + p*((double(fr_bw(i,j)) - mean(i,j,k)))^2); */
               dtemp_1 =  fr_bw_out_1[i1 + 240 * i2] -  mean_3_out[i3][i2][i1];
               dtemp_0 = sqrt( (1.0 - p) * ( sd_3_out[i3][i2][i1] *  sd_3_out[i3][i2][i1]) + p * (dtemp_1 * dtemp_1));
               __CT_ERROR_CHK( __CATALYTIC_isnan(dtemp_0) == 1, "File mixture_of_gaussians_c.m, line 42: Complex output generated by sqrt with real input, fxp_real_mode is on.");
               __CT_DYN_EXT_CHK(i1 > 239, "mixture_of_gaussians_c.m", 42);
               __CT_DYN_EXT_CHK(i2 > 319, "mixture_of_gaussians_c.m", 42);
               __CT_DYN_EXT_CHK(i3 > 2, "mixture_of_gaussians_c.m", 42);
               sd_3_out[i3][i2][i1] = dtemp_0;
            }
            else {

               /* mixture_of_gaussians_c.m:43	                else                                    % pixel doesn't match component */
               /* mixture_of_gaussians_c.m:44	                    w(i,j,k) = (1-alpha)*w(i,j,k);      % weight slighly decreases */

               __CT_DYN_EXT_CHK(i1 > 239, "mixture_of_gaussians_c.m", 44);
               __CT_DYN_EXT_CHK(i2 > 319, "mixture_of_gaussians_c.m", 44);
               __CT_DYN_EXT_CHK(i3 > 2, "mixture_of_gaussians_c.m", 44);
               w_3_out[i3][i2][i1] = (1.0 - alpha) *  w_3_out[i3][i2][i1];
            }
         }
         /* mixture_of_gaussians_c.m:46	                end */
         /* mixture_of_gaussians_c.m:47	            end */
         /* mixture_of_gaussians_c.m:49	            % normalize weights */
         /* mixture_of_gaussians_c.m:50	            w(i,j,:) = w(i,j,:)./sum(w(i,j,:)); */

         dtemp_4 = 0.0;
         for (i3=0; i3<=2; i3+=1) {
            dtemp_4 = dtemp_4 +  w_3_out[i3][i2][i1];
         }
         __CT_DYN_EXT_CHK(!((319 >= i2)&&(239 >= i1)), "mixture_of_gaussians_c.m", 50);
         for (i3=0; i3<=2; i3+=1) {
            w_3_out[i3][i2][i1] =  w_3_out[i3][i2][i1] / dtemp_4;
         }

         /* mixture_of_gaussians_c.m:52	            % if no components match, create new component */
         /* mixture_of_gaussians_c.m:53	            if (match == 0) */

         if (!match) {
            /* mixture_of_gaussians_c.m:54	                [min_w, min_w_index] = min(w(i,j,:));   */
            min_w = HUGE_VAL;
            itemp_9 = 1;
            for (i3=0; i3<=2; i3+=1) {
               if ( w_3_out[i3][i2][i1] < min_w) {
                  min_w = w_3_out[i3][i2][i1];
                  itemp_9 = 1 + i3;
               }
            }
            min_w_index = itemp_9;
            /* mixture_of_gaussians_c.m:55	                mean(i,j,min_w_index) = double(fr_bw(i,j)); */
            __CT_DYN_EXT_CHK(i1 > 239, "mixture_of_gaussians_c.m", 55);
            __CT_DYN_EXT_CHK(i2 > 319, "mixture_of_gaussians_c.m", 55);
            __CT_DYN_EXT_CHK(min_w_index > 3, "mixture_of_gaussians_c.m", 55);
            mean_3_out[min_w_index - 1][i2][i1] = fr_bw_out_1[i1 + 240 * i2];
            /* mixture_of_gaussians_c.m:56	                sd(i,j,min_w_index) = sd_init; */
            __CT_DYN_EXT_CHK(i1 > 239, "mixture_of_gaussians_c.m", 56);
            __CT_DYN_EXT_CHK(i2 > 319, "mixture_of_gaussians_c.m", 56);
            __CT_DYN_EXT_CHK(min_w_index > 3, "mixture_of_gaussians_c.m", 56);
            sd_3_out[min_w_index - 1][i2][i1] = sd_init;
         }

         /* mixture_of_gaussians_c.m:57	            end */
         /* mixture_of_gaussians_c.m:59	            % calculate component rank */
         /* mixture_of_gaussians_c.m:60	            rank = w(i,j,:)./sd(i,j,:);              */

         for (i3=0; i3<=2; i3+=1) {
            rank[i3] =  w_3_out[i3][i2][i1] /  sd_3_out[i3][i2][i1];
         }
         /* mixture_of_gaussians_c.m:61	            rank_ind = [1:1:C]; */
         ct_set_max(rank_ind_dim2, ((int32)C), 0);
         CT_ALLOC(rank_ind, rank_ind_dim2, int32 *);
         for (i3=0; i3<=(((int32)C)) - 1; i3+=1) {
            rank_ind[i3] = 1 + i3;
         }

         /* mixture_of_gaussians_c.m:63	            % sort rank values */
         /* mixture_of_gaussians_c.m:64	            for k=2:C                */

         itemp_5 = ((int32)C);
         for (i3=2; i3<=itemp_5; i3+=1) {
            /* mixture_of_gaussians_c.m:65	                for m=1:(k-1) */
            for (l=0; l<=i3 - 2; l+=1) {
               /* mixture_of_gaussians_c.m:67	                    if (rank(:,:,k) > rank(:,:,m)) */
               if ( rank[i3 - 1] >  rank[l]) {

                  /* mixture_of_gaussians_c.m:68	%                       if (rank(k) > rank(m)) */
                  /* mixture_of_gaussians_c.m:69	                        % swap max values */
                  /* mixture_of_gaussians_c.m:70	                        rank_temp = rank(:,:,m);   */

                  rank_temp = rank[l];
                  /* mixture_of_gaussians_c.m:71	                        rank(:,:,m) = rank(:,:,k); */
                  __CT_DYN_EXT_CHK(l > 2, "mixture_of_gaussians_c.m", 71);
                  rank[l] = rank[i3 - 1];
                  /* mixture_of_gaussians_c.m:72	                        rank(:,:,k) = rank_temp; */
                  __CT_DYN_EXT_CHK(i3 > 3, "mixture_of_gaussians_c.m", 72);
                  rank[i3 - 1] = rank_temp;

                  /* mixture_of_gaussians_c.m:74	                        % swap max index values */
                  /* mixture_of_gaussians_c.m:75	                        rank_ind_temp = rank_ind(m);   */

                  rank_ind_temp = rank_ind[l];
                  /* mixture_of_gaussians_c.m:76	                        rank_ind(m) = rank_ind(k); */
                  itemp_0 = rank_ind[i3 - 1];
                  itemp_3 = rank_ind_dim2;
                  if (  1 - itemp_3 + l > 0) {
                     rank_ind_dim2 = 1 + l;
                     CT_EXT_VEC(rank_ind,1 + l,itemp_3, int32 *);
                  }
                  rank_ind[l] = itemp_0;
                  /* mixture_of_gaussians_c.m:77	                        rank_ind(k) = rank_ind_temp;     */
                  itemp_4 = rank_ind_dim2;
                  if (i3 > itemp_4) {
                     rank_ind_dim2 = i3;
                     CT_EXT_VEC(rank_ind,i3,itemp_4, int32 *);
                  }
                  rank_ind[i3 - 1] = rank_ind_temp;
               }
            }
         }

         /* mixture_of_gaussians_c.m:78	                    end */
         /* mixture_of_gaussians_c.m:79	                end */
         /* mixture_of_gaussians_c.m:80	            end */
         /* mixture_of_gaussians_c.m:82	            % calculate foreground */
         /* mixture_of_gaussians_c.m:83	            match = 0; */

         match = 0;
         /* mixture_of_gaussians_c.m:84	            k=1; */
         k = 1;
         /* mixture_of_gaussians_c.m:86	            fg(i,j) = 0; */
         __CT_DYN_EXT_CHK(  1 - (*fg_out_dim1) + i1 > 0, "mixture_of_gaussians_c.m", 86);
         __CT_DYN_EXT_CHK(  1 - (*fg_out_dim2) + i2 > 0, "mixture_of_gaussians_c.m", 86);
         fg_out_1[ (*fg_out_dim1) * i2 + i1] = 0;
         /* mixture_of_gaussians_c.m:87	            while ((match == 0)&&(k<=M)) */
         while ((!match)&&((((double)k)) <= M)) {
            /* mixture_of_gaussians_c.m:89	                if (w(i,j,rank_ind(k)) >= thresh) */
            if ( w_3_out[ rank_ind[k - 1] - 1][i2][i1] >= thresh) {
               /* mixture_of_gaussians_c.m:90	                    if (abs(u_diff(i,j,rank_ind(k))) <= D*sd(i,j,rank_ind(k))) */
               if ( fabs(u_diff[   u_diff_dim2 * u_diff_dim1 * ( rank_ind[k - 1] - 1) + u_diff_dim1 * i2 + i1]) <= D *  sd_3_out[ rank_ind[k - 1] - 1][i2][i1]) {
                  /* mixture_of_gaussians_c.m:91	                        fg(i,j) = 0; */
                  __CT_DYN_EXT_CHK(  1 - (*fg_out_dim1) + i1 > 0, "mixture_of_gaussians_c.m", 91);
                  __CT_DYN_EXT_CHK(  1 - (*fg_out_dim2) + i2 > 0, "mixture_of_gaussians_c.m", 91);
                  fg_out_1[ (*fg_out_dim1) * i2 + i1] = 0;
                  /* mixture_of_gaussians_c.m:92	                        match = 1; */
                  match = 1;
               }
               else {
                  /* mixture_of_gaussians_c.m:93	                    else */
                  /* mixture_of_gaussians_c.m:94	                        fg(i,j) = 255;%fr_bw (i,j);      */
                  __CT_DYN_EXT_CHK(  1 - (*fg_out_dim1) + i1 > 0, "mixture_of_gaussians_c.m", 94);
                  __CT_DYN_EXT_CHK(  1 - (*fg_out_dim2) + i2 > 0, "mixture_of_gaussians_c.m", 94);
                  fg_out_1[ (*fg_out_dim1) * i2 + i1] = 255;
               }
            }
            /* mixture_of_gaussians_c.m:95	                    end */
            /* mixture_of_gaussians_c.m:96	                end */
            /* mixture_of_gaussians_c.m:97	                k = k+1; */

            k = 1 + k;
         }
      }
   }
   CT_FREE(fr_1);
   CT_FREE(u_diff);
   CT_FREE(I);
   CT_FREE(rank_ind);
   CT_FREE(dtemp_3);
   *fg_out = fg_out_1;
   *fr_bw_out = fr_bw_out_1;
   return;
}
