/**********************************************************/
/* End User Licensee may distribute C code generated from */
/* Catalytic licensed functions only in combination with  */
/* the original work of Licensee.                         */
/**********************************************************/
/******************************************************************/
/* Catalytic MCS-file info                                        */
/* ============================================================== */
/* Created  : Thu Jun 19 18:03:27 2008                            */
/* Command  : ctmcs -gui -single_prec -comments -multi_c -replace_func default -subchk_off -Xdyn_ext_off mixture_of_gaussians_c.m */
/* Version  : 3.2-2781 -- Mon Feb 11 16:21:00 PST 2008            */
/* MATLAB   : 7.5.0.342 (R2007b)                                  */
/* Computer : PCWIN                                               */
/******************************************************************/

#ifndef _CT_MCS_MEX
#  include "ct_target_m2c.h"
#else
#  include "ct_target_mex.h"
#endif

#include "ct_runtime.h"

#include "mixture_of_gaussians_c.h"
/* mixture_of_gaussians_c.m:1	function [fr_bw, fg, w, mean, sd] = mixture_of_gaussians_c(fr,mean,w,sd,alpha,sd_init,thresh,C,D,M,width,height) */
/*************************************************************
 *
 * FUNCTION: _mixture_of_gaussians_c
 *
 *************************************************************/

void  _mixture_of_gaussians_c(float(*(* fr_bw_out)), int32* fr_bw_out_dim1, int32* fr_bw_out_dim2, int32(*(* fg_out)), int32* fg_out_dim1, int32* fg_out_dim2, float w_2_out[3][320][240], float mean_2_out[3][320][240], float sd_2_out[3][320][240], float fr[3][320][240], float mean[3][320][240], float w[3][320][240], float sd[3][320][240], float alpha, float sd_init, float thresh, float C, float D, float M, float width, float height) {
   float *fr_bw_out_1;
   int32 *fg_out_1;
   float *u_diff;
   int32 u_diff_dim1, u_diff_dim2, u_diff_dim3;
   int32 *rank_ind;
   int32 rank_ind_dim2;
   float min_w, p, rank_temp, ftemp_0, ftemp_1;
   float (*fr_1)[3][76800];
   float (*I)[76800];
   int32 match, k, min_w_index, rank_ind_temp, itemp_0;
   float rank[3];
   static float ftemp_2[3] = 
             {
                0.2989, 0.58699999999999997, 0.114
             };
   float (*ftemp_3)[320][240];
   int32 itemp_1, itemp_2, itemp_3, i1, i2;
   float ftemp_4;
   int32 i3, l;

   CT_INIT(fr_bw_out_1);
   CT_INIT(fg_out_1);
   CT_INIT(fr_1);
   CT_ALLOC(fr_1, 1, float (*)[3][76800]);
   CT_INIT(u_diff);
   CT_INIT(I);
   CT_ALLOC(I, 1, float (*)[76800]);
   CT_INIT(rank_ind);
   CT_INIT(ftemp_3);
   CT_ALLOC(ftemp_3, 1, float (*)[320][240]);
   for (i1=0; i1<=2; i1+=1) {
      for (i2=0; i2<=319; i2+=1) {
         for (i3=0; i3<=239; i3+=1) {
            sd_2_out[i1][i2][i3] = sd[i1][i2][i3];
            w_2_out[i1][i2][i3] = w[i1][i2][i3];
            mean_2_out[i1][i2][i3] = mean[i1][i2][i3];
         }
      }
   }
   /* mixture_of_gaussians_c.m:4	    mbreal(fr,mean,w,sd,alpha,sd_init,C,D,M,thresh,width,height); */
   /* mixture_of_gaussians_c.m:5	    mbscalar(thresh,width,height,alpha,sd_init,C,D,M); */
   /* mixture_of_gaussians_c.m:6	    mbsize([240 320 3],fr,mean,w,sd); */
   /* mixture_of_gaussians_c.m:8	    u_diff = zeros(height,width,C);         % difference of each pixel from mean */
   ct_set_max(u_diff_dim1, ((int32)height), 0);
   ct_set_max(u_diff_dim2, ((int32)width), 0);
   ct_set_max(u_diff_dim3, ((int32)C), 0);
   CT_CALLOC(u_diff,  u_diff_dim1 * u_diff_dim2 * u_diff_dim3, float *);
   /* difference of each pixel from mean */
   /*     fr_bw = double(rgb2gray(fr));       % convert frame to grayscale */

   /* mixture_of_gaussians_c.m:10	%     fr_bw = double(rgb2gray(fr));       % convert frame to grayscale */
   /* mixture_of_gaussians_c.m:11	    fg = zeros(height,width);  */
   ct_set_max(*fg_out_dim1, ((int32)height), 0);
   ct_set_max(*fg_out_dim2, ((int32)width), 0);
   CT_CALLOC(fg_out_1, (*fg_out_dim1) * (*fg_out_dim2), int32 *);
   /* mixture_of_gaussians_c.m:13	    origSize = size(fr); */
   /* mixture_of_gaussians_c.m:14	    sizeOutput = [origSize(1), origSize(2)]; */
   /* mixture_of_gaussians_c.m:16	    fr = reshape(fr(:),origSize(1)*origSize(2),3); */
   for (i1=0; i1<=230399; i1+=1) {
      ((float*)(*fr_1))[i1] = ((float*)fr)[i1];
   }
   /* mixture_of_gaussians_c.m:17	    coef = [.2989; .5870; .1140]; */
   /* mixture_of_gaussians_c.m:19	    I = double(fr) * coef; */
   memset((*I), 0, 307200);
   for (i1=0; i1<=2; i1+=1) {
      for (i2=0; i2<=76799; i2+=1) {
         (*I)[i2] =  (*I)[i2] +  (*fr_1)[i1][i2] *  ftemp_2[i1];
      }
   }
   /* mixture_of_gaussians_c.m:20	    fr_bw = reshape(I,sizeOutput);    */
   *fr_bw_out_dim1 = 240;
   *fr_bw_out_dim2 = 320;
   CT_ALLOC(fr_bw_out_1, 76800, float *);
   for (i1=0; i1<=76799; i1+=1) {
      fr_bw_out_1[i1] = (*I)[i1];
   }
   /* calculate difference of pixel values from mean */

   /* mixture_of_gaussians_c.m:22	    % calculate difference of pixel values from mean */
   /* mixture_of_gaussians_c.m:23	    for m=1:C */
   for (i1=0; i1<=(((int32)C)) - 1; i1+=1) {
      /* mixture_of_gaussians_c.m:24	        u_diff(:,:,m) = double(fr_bw) - mean(:,:,m); */
      for (i2=0; i2<=319; i2+=1) {
         for (i3=0; i3<=239; i3+=1) {
            (*ftemp_3)[i2][i3] =  fr_bw_out_1[ 240 * i2 + i3] -  mean[i1][i2][i3];
         }
      }
      ct_set_max(itemp_0, u_diff_dim1, 0);
      ct_set_max(itemp_1, u_diff_dim2, 0);
      __CT_DYN_EXT_CHK((itemp_0 != 0)&&(1 > u_diff_dim1), "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 24);
      __CT_DYN_EXT_CHK((itemp_1 != 0)&&(1 > u_diff_dim2), "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 24);
      __CT_DYN_EXT_CHK(  1 - u_diff_dim3 + i1 > 0, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 24);
      __CT_ASGN_DIM_CHK((itemp_1 != 1)&&(  (itemp_1 > 1) - 2 + (itemp_0 > 1) != 0), "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 24);
      __CT_ASGN_CHK( itemp_0 * itemp_1 - 76800, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 24);
      itemp_2 = 0;
      for (i2=0; i2<=itemp_1 - 1; i2+=1) {
         for (i3=0; i3<=itemp_0 - 1; i3+=1) {
            u_diff[   u_diff_dim2 * u_diff_dim1 * i1 + u_diff_dim1 * i2 + i3] = ((float*)(*ftemp_3))[itemp_2];
            itemp_2 = 1 + itemp_2;
         }
      }
   }
   /* update gaussian components for each pixel */

   /* mixture_of_gaussians_c.m:25	    end */
   /* mixture_of_gaussians_c.m:27	    % update gaussian components for each pixel */
   /* mixture_of_gaussians_c.m:28	    for i=1:height */
   for (i1=0; i1<=(((int32)height)) - 1; i1+=1) {
      /* mixture_of_gaussians_c.m:29	        for j=1:width */
      for (i2=0; i2<=(((int32)width)) - 1; i2+=1) {
         /* mixture_of_gaussians_c.m:31	            match = 0; */
         match = 0;
         /* mixture_of_gaussians_c.m:32	            for k=1:C            */
         for (i3=0; i3<=(((int32)C)) - 1; i3+=1) {
            /* mixture_of_gaussians_c.m:34	                if (abs(u_diff(i,j,k)) <= D*sd(i,j,k))       % pixel matches component */
            if ( fabs(u_diff[   u_diff_dim2 * u_diff_dim1 * i3 + u_diff_dim1 * i2 + i1]) <= D *  sd_2_out[i3][i2][i1]) {
               /* pixel matches component */

               /* mixture_of_gaussians_c.m:36	                    match = 1;                          % variable to signal component match */
               match = 1;
               /* variable to signal component match */
               /* update weights, mean, sd, p */

               /* mixture_of_gaussians_c.m:38	                    % update weights, mean, sd, p */
               /* mixture_of_gaussians_c.m:39	                    w(i,j,k) = (1-alpha)*w(i,j,k) + alpha; */
               __CT_DYN_EXT_CHK(i1 > 239, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 39);
               __CT_DYN_EXT_CHK(i2 > 319, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 39);
               __CT_DYN_EXT_CHK(i3 > 2, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 39);
               w_2_out[i3][i2][i1] =  (1.0 - alpha) *  w_2_out[i3][i2][i1] + alpha;
               /* mixture_of_gaussians_c.m:40	                    p = alpha/w(i,j,k);                   */
               p = alpha /  w_2_out[i3][i2][i1];
               /* mixture_of_gaussians_c.m:41	                    mean(i,j,k) = (1-p)*mean(i,j,k) + p*double(fr_bw(i,j)); */
               __CT_DYN_EXT_CHK(i1 > 239, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 41);
               __CT_DYN_EXT_CHK(i2 > 319, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 41);
               __CT_DYN_EXT_CHK(i3 > 2, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 41);
               mean_2_out[i3][i2][i1] =  (1.0 - p) *  mean_2_out[i3][i2][i1] + p *  fr_bw_out_1[i1 + 240 * i2];
               /* mixture_of_gaussians_c.m:42	                    sd(i,j,k) =   sqrt((1-p)*(sd(i,j,k)^2) + p*((double(fr_bw(i,j)) - mean(i,j,k)))^2); */
               ftemp_1 =  fr_bw_out_1[i1 + 240 * i2] -  mean_2_out[i3][i2][i1];
               ftemp_0 = sqrt( (1.0 - p) * ( sd_2_out[i3][i2][i1] *  sd_2_out[i3][i2][i1]) + p * (ftemp_1 * ftemp_1));
               __CT_ERROR_CHK( __CATALYTIC_isnan(ftemp_0) == 1, "File C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m, line 42: Complex output generated by sqrt with real input, fxp_real_mode is on.");
               __CT_DYN_EXT_CHK(i1 > 239, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 42);
               __CT_DYN_EXT_CHK(i2 > 319, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 42);
               __CT_DYN_EXT_CHK(i3 > 2, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 42);
               sd_2_out[i3][i2][i1] = ftemp_0;
            }
            else {
               /* pixel doesn't match component */

               /* mixture_of_gaussians_c.m:43	                else                                    % pixel doesn't match component */
               /* mixture_of_gaussians_c.m:44	                    w(i,j,k) = (1-alpha)*w(i,j,k);      % weight slighly decreases */
               __CT_DYN_EXT_CHK(i1 > 239, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 44);
               __CT_DYN_EXT_CHK(i2 > 319, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 44);
               __CT_DYN_EXT_CHK(i3 > 2, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 44);
               w_2_out[i3][i2][i1] = (1.0 - alpha) *  w_2_out[i3][i2][i1];
               /* weight slighly decreases */
            }
         }
         /* normalize weights */

         /* mixture_of_gaussians_c.m:46	                end */
         /* mixture_of_gaussians_c.m:47	            end */
         /* mixture_of_gaussians_c.m:49	            % normalize weights */
         /* mixture_of_gaussians_c.m:50	            w(i,j,:) = w(i,j,:)./sum(w(i,j,:)); */
         ftemp_4 = 0.0;
         for (i3=0; i3<=2; i3+=1) {
            ftemp_4 = ftemp_4 +  w_2_out[i3][i2][i1];
         }
         __CT_DYN_EXT_CHK(!((319 >= i2)&&(239 >= i1)), "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 50);
         for (i3=0; i3<=2; i3+=1) {
            w_2_out[i3][i2][i1] =  w_2_out[i3][i2][i1] / ftemp_4;
         }
         /* if no components match, create new component */

         /* mixture_of_gaussians_c.m:52	            % if no components match, create new component */
         /* mixture_of_gaussians_c.m:53	            if (match == 0) */
         if (!match) {
            /* mixture_of_gaussians_c.m:54	                [min_w, min_w_index] = min(w(i,j,:));   */
            min_w = HUGE_VAL;
            itemp_3 = 1;
            for (i3=0; i3<=2; i3+=1) {
               if ( w_2_out[i3][i2][i1] < min_w) {
                  min_w = w_2_out[i3][i2][i1];
                  itemp_3 = 1 + i3;
               }
            }
            min_w_index = itemp_3;
            /* mixture_of_gaussians_c.m:55	                mean(i,j,min_w_index) = double(fr_bw(i,j)); */
            __CT_DYN_EXT_CHK(i1 > 239, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 55);
            __CT_DYN_EXT_CHK(i2 > 319, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 55);
            __CT_DYN_EXT_CHK(min_w_index > 3, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 55);
            mean_2_out[min_w_index - 1][i2][i1] = fr_bw_out_1[i1 + 240 * i2];
            /* mixture_of_gaussians_c.m:56	                sd(i,j,min_w_index) = sd_init; */
            __CT_DYN_EXT_CHK(i1 > 239, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 56);
            __CT_DYN_EXT_CHK(i2 > 319, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 56);
            __CT_DYN_EXT_CHK(min_w_index > 3, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 56);
            sd_2_out[min_w_index - 1][i2][i1] = sd_init;
         }
         /* calculate component rank */

         /* mixture_of_gaussians_c.m:57	            end */
         /* mixture_of_gaussians_c.m:59	            % calculate component rank */
         /* mixture_of_gaussians_c.m:60	            rank = w(i,j,:)./sd(i,j,:);              */
         for (i3=0; i3<=2; i3+=1) {
            rank[i3] =  w_2_out[i3][i2][i1] /  sd_2_out[i3][i2][i1];
         }
         /* mixture_of_gaussians_c.m:61	            rank_ind = [1:1:C]; */
         ct_set_max(rank_ind_dim2, ((int32)C), 0);
         CT_ALLOC(rank_ind, rank_ind_dim2, int32 *);
         for (i3=0; i3<=(((int32)C)) - 1; i3+=1) {
            rank_ind[i3] = 1 + i3;
         }
         /* sort rank values */

         /* mixture_of_gaussians_c.m:63	            % sort rank values */
         /* mixture_of_gaussians_c.m:64	            for k=2:C                */
         for (i3=2; i3<=((int32)C); i3+=1) {
            /* mixture_of_gaussians_c.m:65	                for m=1:(k-1) */
            for (l=0; l<=i3 - 2; l+=1) {
               /* mixture_of_gaussians_c.m:67	                    if (rank(:,:,k) > rank(:,:,m)) */
               if ( rank[i3 - 1] >  rank[l]) {
                  /*                       if (rank(k) > rank(m)) */
                  /* swap max values */

                  /* mixture_of_gaussians_c.m:68	%                       if (rank(k) > rank(m)) */
                  /* mixture_of_gaussians_c.m:69	                        % swap max values */
                  /* mixture_of_gaussians_c.m:70	                        rank_temp = rank(:,:,m);   */
                  rank_temp = rank[l];
                  /* mixture_of_gaussians_c.m:71	                        rank(:,:,m) = rank(:,:,k); */
                  __CT_DYN_EXT_CHK(l > 2, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 71);
                  rank[l] = rank[i3 - 1];
                  /* mixture_of_gaussians_c.m:72	                        rank(:,:,k) = rank_temp; */
                  __CT_DYN_EXT_CHK(i3 > 3, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 72);
                  rank[i3 - 1] = rank_temp;
                  /* swap max index values */

                  /* mixture_of_gaussians_c.m:74	                        % swap max index values */
                  /* mixture_of_gaussians_c.m:75	                        rank_ind_temp = rank_ind(m);   */
                  rank_ind_temp = rank_ind[l];
                  /* mixture_of_gaussians_c.m:76	                        rank_ind(m) = rank_ind(k); */
                  __CT_DYN_EXT_CHK(  1 - rank_ind_dim2 + l > 0, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 76);
                  rank_ind[l] = rank_ind[i3 - 1];
                  /* mixture_of_gaussians_c.m:77	                        rank_ind(k) = rank_ind_temp;     */
                  __CT_DYN_EXT_CHK(i3 > rank_ind_dim2, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 77);
                  rank_ind[i3 - 1] = rank_ind_temp;
               }
            }
         }
         /* calculate foreground */

         /* mixture_of_gaussians_c.m:78	                    end */
         /* mixture_of_gaussians_c.m:79	                end */
         /* mixture_of_gaussians_c.m:80	            end */
         /* mixture_of_gaussians_c.m:82	            % calculate foreground */
         /* mixture_of_gaussians_c.m:83	            match = 0; */
         match = 0;
         /* mixture_of_gaussians_c.m:84	            k=1; */
         k = 1;
         /* mixture_of_gaussians_c.m:86	            fg(i,j) = 0; */
         __CT_DYN_EXT_CHK(  1 - (*fg_out_dim1) + i1 > 0, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 86);
         __CT_DYN_EXT_CHK(  1 - (*fg_out_dim2) + i2 > 0, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 86);
         fg_out_1[ (*fg_out_dim1) * i2 + i1] = 0;
         /* mixture_of_gaussians_c.m:87	            while ((match == 0)&&(k<=M)) */
         while ((!match)&&((((float)k)) <= M)) {
            /* mixture_of_gaussians_c.m:89	                if (w(i,j,rank_ind(k)) >= thresh) */
            if ( w_2_out[ rank_ind[k - 1] - 1][i2][i1] >= thresh) {
               /* mixture_of_gaussians_c.m:90	                    if (abs(u_diff(i,j,rank_ind(k))) <= D*sd(i,j,rank_ind(k))) */
               if ( fabs(u_diff[   u_diff_dim2 * u_diff_dim1 * ( rank_ind[k - 1] - 1) + u_diff_dim1 * i2 + i1]) <= D *  sd_2_out[ rank_ind[k - 1] - 1][i2][i1]) {
                  /* mixture_of_gaussians_c.m:91	                        fg(i,j) = 0; */
                  __CT_DYN_EXT_CHK(  1 - (*fg_out_dim1) + i1 > 0, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 91);
                  __CT_DYN_EXT_CHK(  1 - (*fg_out_dim2) + i2 > 0, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 91);
                  fg_out_1[ (*fg_out_dim1) * i2 + i1] = 0;
                  /* mixture_of_gaussians_c.m:92	                        match = 1; */
                  match = 1;
               }
               else {
                  /* mixture_of_gaussians_c.m:93	                    else */
                  /* mixture_of_gaussians_c.m:94	                        fg(i,j) = 255;%fr_bw (i,j);      */
                  __CT_DYN_EXT_CHK(  1 - (*fg_out_dim1) + i1 > 0, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 94);
                  __CT_DYN_EXT_CHK(  1 - (*fg_out_dim2) + i2 > 0, "C:\\M-FILES\\Background_Subtraction\\mixture_of_gaussians_c.m", 94);
                  fg_out_1[ (*fg_out_dim1) * i2 + i1] = 255;
                  /*fr_bw (i,j);      */
               }
            }
            /* mixture_of_gaussians_c.m:95	                    end */
            /* mixture_of_gaussians_c.m:96	                end */
            /* mixture_of_gaussians_c.m:97	                k = k+1; */
            k = 1 + k;
         }
      }
   }
   CT_FREE(fr_1);
   CT_FREE(u_diff);
   CT_FREE(I);
   CT_FREE(rank_ind);
   CT_FREE(ftemp_3);
   *fg_out = fg_out_1;
   *fr_bw_out = fr_bw_out_1;
   return;
}
