% This function implements the mixture of Gaussians algorithm for background
% subtraction.  It may be used free of charge for any purpose (commercial
% or otherwise), as long as the author (Seth Benton) is acknowledged.


function [fr_bw, fg, w, mean, sd] = mixture_of_gaussians_c(fr,mean,w,sd,alpha,sd_init,thresh,C,D,M,width,height)

 
    mbreal(fr,mean,w,sd,alpha,sd_init,C,D,M,thresh,width,height);
    mbscalar(thresh,width,height,alpha,sd_init,C,D,M);
    mbsize([240 320 3],fr,mean,w,sd);

    u_diff = zeros(height,width,C);         % difference of each pixel from mean

%     fr_bw = double(rgb2gray(fr));       % convert frame to grayscale
    fg = zeros(height,width); 

    origSize = size(fr);
    sizeOutput = [origSize(1), origSize(2)];

    fr = reshape(fr(:),origSize(1)*origSize(2),3);
    coef = [.2989; .5870; .1140];

    I = double(fr) * coef;
    fr_bw = reshape(I,sizeOutput);   

    % calculate difference of pixel values from mean
    for m=1:C
        u_diff(:,:,m) = double(fr_bw) - mean(:,:,m);
    end
     
    % update gaussian components for each pixel
    for i=1:height
        for j=1:width
            
            match = 0;
            for k=1:C           
                
                if (abs(u_diff(i,j,k)) <= D*sd(i,j,k))       % pixel matches component
                    
                    match = 1;                          % variable to signal component match
                    
                    % update weights, mean, sd, p
                    w(i,j,k) = (1-alpha)*w(i,j,k) + alpha;
                    p = alpha/w(i,j,k);                  
                    mean(i,j,k) = (1-p)*mean(i,j,k) + p*double(fr_bw(i,j));
                    sd(i,j,k) =   sqrt((1-p)*(sd(i,j,k)^2) + p*((double(fr_bw(i,j)) - mean(i,j,k)))^2);
                else                                    % pixel doesn't match component
                    w(i,j,k) = (1-alpha)*w(i,j,k);      % weight slighly decreases
                    
                end
            end
            
            % normalize weights
            w(i,j,:) = w(i,j,:)./sum(w(i,j,:));
            
            % if no components match, create new component
            if (match == 0)
                [min_w, min_w_index] = min(w(i,j,:));  
                mean(i,j,min_w_index) = double(fr_bw(i,j));
                sd(i,j,min_w_index) = sd_init;
            end
            
            % calculate component rank
            rank = w(i,j,:)./sd(i,j,:);             
            rank_ind = [1:1:C];
            
            % sort rank values
            for k=2:C               
                for m=1:(k-1)
                    
                    if (rank(:,:,k) > rank(:,:,m))
%                       if (rank(k) > rank(m))
                        % swap max values
                        rank_temp = rank(:,:,m);  
                        rank(:,:,m) = rank(:,:,k);
                        rank(:,:,k) = rank_temp;
                        
                        % swap max index values
                        rank_ind_temp = rank_ind(m);  
                        rank_ind(m) = rank_ind(k);
                        rank_ind(k) = rank_ind_temp;    
                    end
                end
            end
         
            % calculate foreground
            match = 0;
            k=1;
            
            fg(i,j) = 0;
            while ((match == 0)&&(k<=M))
    
                if (w(i,j,rank_ind(k)) >= thresh)
                    if (abs(u_diff(i,j,rank_ind(k))) <= D*sd(i,j,rank_ind(k)))
                        fg(i,j) = 0;
                        match = 1;
                    else
                        fg(i,j) = 255;%fr_bw (i,j);     
                    end
                end
                k = k+1;
            end     
        end
    end



