function varargout = bg_sub_mog_gui2(varargin)
% BG_SUB_MOG_GUI2 M-file for bg_sub_mog_gui2.fig
%      BG_SUB_MOG_GUI2, by itself, creates a new BG_SUB_MOG_GUI2 or raises the existing
%      singleton*.
%
%      H = BG_SUB_MOG_GUI2 returns the handle to a new BG_SUB_MOG_GUI2 or the handle to
%      the existing singleton*.
%
%      BG_SUB_MOG_GUI2('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in BG_SUB_MOG_GUI2.M with the given input arguments.
%
%      BG_SUB_MOG_GUI2('Property','Value',...) creates a new BG_SUB_MOG_GUI2 or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before bg_sub_mog_gui2_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to bg_sub_mog_gui2_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help bg_sub_mog_gui2

% Last Modified by GUIDE v2.5 05-Jun-2008 13:36:56

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @bg_sub_mog_gui2_OpeningFcn, ...
                   'gui_OutputFcn',  @bg_sub_mog_gui2_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before bg_sub_mog_gui2 is made visible.
function bg_sub_mog_gui2_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to bg_sub_mog_gui2 (see VARARGIN)

% Choose default command line output for bg_sub_gui2
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

slider1_val = get(handles.slider1,'value');
set(handles.text1,'String',num2str(slider1_val));

thresh = slider1_val;
        
source = aviread('C:\Video\Source\traffic\san_fran_traffic_30sec_QVGA');
% source = aviread('san_fran_traffic_30sec_QVGA_Cinepak');


pixel_depth = 8;                        % 8-bit resolution
pixel_range = 2^pixel_depth -1;         % pixel range (# of possible values)

% -----------------------  frame size variables -----------------------

fr = source(1).cdata;           % read in 1st frame as background frame
fr_bw = rgb2gray(fr);     % convert background to greyscale
fr_size = size(fr);             
width = fr_size(2);
height = fr_size(1);
fg = zeros(height, width);

% --------------------- mog variables -----------------------------------

C = 3;                                  % number of gaussian components (typically 3-5)\
M = 3;                                  % number of background components
D = 2.5;                                % positive deviation threshold
alpha = 0.01;                           % learning rate (between 0 and 1) (from paper 0.01)
thresh = 0.25;                          % foreground threshold (0.25 or 0.75 in paper)
sd_init = 6;                            % initial standard deviation (for new components) var = 36 in paper
w = zeros(height,width,C);              % initialize weights array
mean = zeros(height,width,C);           % pixel means
sd = zeros(height,width,C);             % pixel standard deviations
u_diff = zeros(height,width,C);         % difference of each pixel from mean
p = alpha/(1/C);                        % initial p variable (used to update mean and sd)
rank = zeros(1,C);                      % rank of components (w/sd)


% --------------------- initialize component means and weights -----------

for i=1:height
    for j=1:width
        for k=1:C
            
            mean(i,j,k) = rand*pixel_range;     % means random (0-255)
            w(i,j,k) = 1/C;                     % weights uniformly dist
            sd(i,j,k) = sd_init;                % initialize to sd_init
            
        end
    end
end


for n = 1:70%length(source)

    n
    fr = source(n).cdata;       % read in frame
    fr_bw = rgb2gray(fr);       % convert frame to grayscale

    % calculate difference of pixel values from mean
    for m=1:C
        u_diff(:,:,m) = abs(double(fr_bw) - double(mean(:,:,m)));
    end
     
    % update gaussian components for each pixel
    for i=1:height
        for j=1:width
            
            match = 0;
            for k=1:C           
                
                if (abs(u_diff(i,j,k)) <= D*sd(i,j,k))       % pixel matches component
                    
                    match = 1;                          % variable to signal component match
                    
                    % update weights, mean, sd, p
                    w(i,j,k) = (1-alpha)*w(i,j,k) + alpha;
                    p = alpha/w(i,j,k);                  
                    mean(i,j,k) = (1-p)*mean(i,j,k) + p*double(fr_bw(i,j));
                    sd(i,j,k) =   sqrt((1-p)*(sd(i,j,k)^2) + p*((double(fr_bw(i,j)) - mean(i,j,k)))^2);
                else                                    % pixel doesn't match component
                    w(i,j,k) = (1-alpha)*w(i,j,k);      % weight slighly decreases
                    
                end
            end
            
            w(i,j,:) = w(i,j,:)./sum(w(i,j,:));
            
            % if no components match, create new component
            if (match == 0)
                [min_w, min_w_index] = min(w(i,j,:));  
                mean(i,j,min_w_index) = double(fr_bw(i,j));
                sd(i,j,min_w_index) = sd_init;
            end

            rank = w(i,j,:)./sd(i,j,:);             % calculate component rank
            rank_ind = [1:1:C];
            
            for k=2:C               
                for m=1:(k-1)
                    
                    if (rank(:,:,k) > rank(:,:,m))
%                       if (rank(k) > rank(m))
                        % swap max values
                        rank_temp = rank(:,:,m);  
                        rank(:,:,m) = rank(:,:,k);
                        rank(:,:,k) = rank_temp;

                        % swap max index values
                        rank_ind_temp = rank_ind(m);  
                        rank_ind(m) = rank_ind(k);
                        rank_ind(k) = rank_ind_temp;    
                    end
                end
            end

            % calculate foreground
            match = 0;
            k=1;
            
            fg(i,j) = 0;
            while ((match == 0)&&(k<=M))   
%                 if (rank(k) >= thresh)
                if (w(i,j,rank_ind(k)) >= thresh)
                    
%                     if (abs(u_diff(i,j,rank_ind(k))) <= D*sd(i,j,rank_ind(k)))
                    if (abs(u_diff(i,j,rank_ind(k))) <= D*sd(i,j,rank_ind(k)))
                        fg(i,j) = 0;
                        match = 1;
                    else
                        fg(i,j) = 255;%fr_bw (i,j);     
                    end
                end
                k = k+1;
            end
       
        end
    end
    
axes(handles.axes1); 
imshow(uint8(fg))

    
end
handles.thresh = thresh;

save('gui_vars','w','u_diff','sd','fg','height','width') 


guidata(hObject,handles)

set(handles.slider1,'value',thresh)
set(handles.text1,'String',num2str(thresh));
axes(handles.axes1); 
imshow(uint8(fg))
    
    guidata(hObject, handles);

% --- Outputs from this function are returned to the command line.
function varargout = bg_sub_mog_gui2_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on slider movement.
function slider1_Callback(hObject, eventdata, handles)
% hObject    handle to slider1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
% source = aviread('C:\Video\Source\traffic\mission_traffic2_15sec_QVGA');

slider1_val = get(handles.slider1,'value');
set(handles.text1,'String',num2str(slider1_val));

thresh = slider1_val;
        
load gui_vars



% --------------------- mog variables -----------------------------------

C = 3;                                  % number of gaussian components (typically 3-5)\
M = 3;                                  % number of background components
D = 2.5;                                % positive deviation threshold

    for i=1:height
        for j=1:width

            rank = w(i,j,:)./sd(i,j,:);             % calculate component rank

            rank_ind = [1:1:C];
            
            for k=2:C               
                for m=1:(k-1)
                    
                    if (rank(:,:,k) > rank(:,:,m))
%                       if (rank(k) > rank(m))
                        % swap max values
                        rank_temp = rank(:,:,m);  
                        rank(:,:,m) = rank(:,:,k);
                        rank(:,:,k) = rank_temp;

                        rank_ind_temp = rank_ind(m);  
                        rank_ind(m) = rank_ind(k);
                        rank_ind(k) = rank_ind_temp;    

                    end
                end
            end
            
            
            % calculate foreground
            match = 0;
            k=1;
            
            fg(i,j) = 0;
            while ((match == 0)&&(k<=M))
              
%                 if (rank(k) >= thresh)
                if (w(i,j,rank_ind(k)) >= thresh)
                    
%                     if (abs(u_diff(i,j,rank_ind(k))) <= D*sd(i,j,rank_ind(k)))
                    if (abs(u_diff(i,j,rank_ind(k))) <= D*sd(i,j,rank_ind(k)))
                        fg(i,j) = 0;
                        match = 1;
                    else
                        fg(i,j) = 255;%fr_bw (i,j);     
                    end
                end
                k = k+1;
            end
    
        end
    end

axes(handles.axes1); 
imshow(uint8(fg))  
    

handles.thresh = thresh;

guidata(hObject,handles)


set(handles.slider1,'value',thresh)
set(handles.text1,'String',num2str(thresh));

axes(handles.axes1); 
imshow(uint8(fg))
    
    guidata(hObject, handles);



% --- Executes during object creation, after setting all properties.
function slider1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


