% This m-file implements the frame difference algorithm for background
% subtraction.  It may be used free of charge for any purpose (commercial
% or otherwise), as long as the author (Seth Benton) is acknowledged.

clear all

% source = aviread('C:\Video\Source\traffic\san_fran_traffic_30sec_QVGA');
source = aviread('..\test_video\san_fran_traffic_30sec_QVGA_Cinepak');

thresh = 25;           

bg = source(1).cdata;           % read in 1st frame as background frame
bg_bw = rgb2gray(bg);     % convert background to greyscale


% ----------------------- set frame size variables -----------------------
fr_size = size(bg);             
width = fr_size(2);
height = fr_size(1);
fg = zeros(height, width);


% --------------------- process frames -----------------------------------

fxp_init('sw');                 % initialize Catalytic fixed-point libraries 

for i = 2:length(source)
    
    fr = source(i).cdata;       % read in frame
    

    fr_fxp_r = fxp(double(fr(:,:,1)),8,0,'u');
    fr_fxp_g = fxp(double(fr(:,:,2)),8,0,'u');
    fr_fxp_b = fxp(double(fr(:,:,3)),8,0,'u');
    bg_bw_fxp = fxp(double(bg_bw),8,0,'u');
    

    [fr_bw, fg, bg_bw ] = fr_diff_ct(bg_bw_fxp,fr_fxp_r,fr_fxp_g,fr_fxp_b,thresh,width,height);
   
    figure(1),subplot(3,1,1),imshow(fr)
    subplot(3,1,2),imshow(uint8(fr_bw))
    subplot(3,1,3),imshow(uint8(fg))
  
%     pause   
    
end

    
    