% This m-function implements the frame difference algorithm for background
% subtraction.  It may be used free of charge for any purpose (commercial
% or otherwise), as long as the author (Seth Benton) is acknowledged.

function [fr_bw, fg] = frame_difference_c(bg_bw_fxp,fr_fxp_r,fr_fxp_g,fr_fxp_b,thresh,width,height)

fxp_init('sw');  

mbreal(thresh,width,height);
mbscalar(thresh,width,height);
mbfxpmatrix(8,0,'u',bg_bw_fxp,fr_fxp_r,fr_fxp_g,fr_fxp_b);    
mbsize([240 320],fr_fxp_r,fr_fxp_g,fr_fxp_b);
 
% -----------------------rgb2gray--------------------

origSize = size(fr_fxp_r);
sizeOutput = [origSize(1), origSize(2)];

X = zeros(origSize(1)*origSize(2),3);

X(:,1) = reshape(fr_fxp_r,origSize(1)*origSize(2),1);
X(:,2) = reshape(fr_fxp_g,origSize(1)*origSize(2),1);
X(:,3) = reshape(fr_fxp_b,origSize(1)*origSize(2),1);

coef = [.2989; .5870; .1140];

I = double(X) * coef;
fr_bw = reshape(I,sizeOutput);   

% subtract frame from background
fr_diff =  abs(double(fr_bw) - double(bg_bw_fxp));

fg = zeros(height, width);

% threshold foreground pixels
for j=1:width                 % if fr_diff > thresh pixel in foreground
     for k=1:height
         if ((fr_diff(k,j) > thresh))
             fg(k,j) = fr_bw(k,j);
         else
             fg(k,j) = 0;
         end
     end
     
end



