function varargout = bg_sub_gui2(varargin)
% BG_SUB_GUI2 M-file for bg_sub_gui2.fig
%      BG_SUB_GUI2, by itself, creates a new BG_SUB_GUI2 or raises the existing
%      singleton*.
%
%      H = BG_SUB_GUI2 returns the handle to a new BG_SUB_GUI2 or the handle to
%      the existing singleton*.
%
%      BG_SUB_GUI2('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in BG_SUB_GUI2.M with the given input arguments.
%
%      BG_SUB_GUI2('Property','Value',...) creates a new BG_SUB_GUI2 or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before bg_sub_gui2_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to bg_sub_gui2_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help bg_sub_gui2

% Last Modified by GUIDE v2.5 14-Apr-2008 15:31:53

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @bg_sub_gui2_OpeningFcn, ...
                   'gui_OutputFcn',  @bg_sub_gui2_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before bg_sub_gui2 is made visible.
function bg_sub_gui2_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to bg_sub_gui2 (see VARARGIN)

% Choose default command line output for bg_sub_gui2
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes bg_sub_gui2 wait for user response (see UIRESUME)
% uiwait(handles.figure1);
source = aviread('C:\Video\Source\traffic\mission_traffic2_15sec_QVGA');

% thresh_norm = (0.2)
% thresh = thresh_norm*(255);           
thresh = 25;
% thresh_v = [0:0.1:1]*255

bg = source(1).cdata;           % read in 1st frame as background frame
bg_bw = int8(rgb2gray(bg));

fr_size = size(bg);
width = fr_size(2);
height = fr_size(1);
fg = zeros(height, width);

% figure(1),imshow(bg)

for i = 2:2%length(source)
    
    fr = source(i).cdata;       % read in frame
    fr_bw = rgb2gray(fr);       % convert frame to grayscale
    
    fr_diff = abs(int8(fr_bw) - bg_bw);
    
    %thresh = thresh_v(i)
       
    for j=1:width
        for k=1:height
            if ((fr_diff(k,j) > thresh))
                fg(k,j) = fr_bw(k,j);
            else
                fg(k,j) = 0;
            end
        end
    end
    
    bg = fr;
    
    %     subplot(3,1,1),imshow(fr)
%     subplot(3,1,2),imshow(bg)
%     subplot(3,1,3),imshow(fg)
% 
%     figure(1),subplot(3,1,1),imshow(fr_diff)
%     subplot(3,1,2),imshow(fr_bw)
%     subplot(3,1,3),imshow(fg)
   
%     pause   
    
end

handles.thresh = thresh;
% handles.h_env = h_env;
% handles.v_env = v_env;
% handles.h_len = h_len;
% handles.sd_v_upper = sd_v_upper;
% handles.sd_v_lower = sd_v_lower;
% handles.sd_h = sd_h;

% handles.fr_edge_env = fr_edge_env;
% handles.fr_edge = fr_edge;
% handles.src = src;
% handles.fr = fr;
% handles.out_vid = out_vid;



guidata(hObject,handles)

% sd_v_upper = get(handles.sd_v_upper,'value');
set(handles.slider1,'value',thresh)
set(handles.text1,'String',num2str(thresh));
% set(handles.valText,'String',num2str(thresh));

% set(handles.slider3,'value',sd_v_lower)
% set(handles.text6,'String',num2str(sd_v_lower));
% set(handles.slider1,'value',sd_h)
% set(handles.text5,'String',num2str(sd_h));

% axes(handles.axes1); 
% imshow(uint8(fr_bw))
axes(handles.axes1); 
imshow(uint8(fg))
% axes(handles.axes2);
% imshow(uint8(fg))

% --- Outputs from this function are returned to the command line.
function varargout = bg_sub_gui2_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on slider movement.
function slider1_Callback(hObject, eventdata, handles)
% hObject    handle to slider1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
% source = aviread('san_fran_traffic_30sec_QVGA');
source = aviread('san_fran_traffic_30sec_QVGA_Cinepak');

slider1_val = get(handles.slider1,'value');
set(handles.text1,'String',num2str(slider1_val));

thresh = slider1_val;
        

% thresh_v = [0:0.1:1]*255

bg = source(1).cdata;           % read in 1st frame as background frame
bg_bw = int8(rgb2gray(bg));

fr_size = size(bg);
width = fr_size(2);
height = fr_size(1);
fg = zeros(height, width);

% figure(1),imshow(bg)

for i = 2:60%length(source)
    
    fr = source(i).cdata;       % read in frame
    fr_bw = rgb2gray(fr);       % convert frame to grayscale
    
    fr_diff = abs(int8(fr_bw) - bg_bw);
    
    %thresh = thresh_v(i)
       
    for j=1:width
        for k=1:height
            if ((fr_diff(k,j) > thresh))
                fg(k,j) = fr_bw(k,j);
            else
                fg(k,j) = 0;
            end
        end
    end
    
    bg = fr;
    
    %     subplot(3,1,1),imshow(fr)
%     subplot(3,1,2),imshow(bg)
%     subplot(3,1,3),imshow(fg)
% 
%     figure(1),subplot(3,1,1),imshow(fr_diff)
%     subplot(3,1,2),imshow(fr_bw)
%     subplot(3,1,3),imshow(fg)
   
%     pause   
%     axes(handles.axes1); 
%     imshow(uint8(fr_bw))
    axes(handles.axes1); 
    imshow(uint8(fg))
%     axes(handles.axes2);
%     imshow(uint8(fg))
    
    guidata(hObject, handles);

end

% --- Executes during object creation, after setting all properties.
function slider1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


