function varargout = bg_sub_gui(varargin)
% BG_SUB_GUI M-file for bg_sub_gui.fig
%      BG_SUB_GUI, by itself, creates a new BG_SUB_GUI or raises the existing
%      singleton*.
%
%      H = BG_SUB_GUI returns the handle to a new BG_SUB_GUI or the handle to
%      the existing singleton*.
%
%      BG_SUB_GUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in BG_SUB_GUI.M with the given input arguments.
%
%      BG_SUB_GUI('Property','Value',...) creates a new BG_SUB_GUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before bg_sub_gui_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to bg_sub_gui_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help bg_sub_gui

% Last Modified by GUIDE v2.5 12-Apr-2008 16:03:35

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @bg_sub_gui_OpeningFcn, ...
                   'gui_OutputFcn',  @bg_sub_gui_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before bg_sub_gui is made visible.
function bg_sub_gui_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to bg_sub_gui (see VARARGIN)

% Choose default command line output for bg_sub_gui
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes bg_sub_gui wait for user response (see UIRESUME)
% uiwait(handles.figure1);

source = aviread('C:\Video\Source\traffic\san_fran_traffic_30sec_QVGA');
% source = aviread('san_fran_traffic_30sec_QVGA_Cinepak');

thresh_norm = (0.2);
thresh = thresh_norm*(255);           



bg = source(1).cdata;           % read in 1st frame as background frame
bg_bw = int8(rgb2gray(bg));

fr_size = size(bg);
width = fr_size(2);
height = fr_size(1);
fg = zeros(height, width);

for i = 2:2%length(source)
    
    fr = source(i).cdata;       % read in frame
    fr_bw = rgb2gray(fr);       % convert frame to grayscale
    
    fr_diff = abs(int8(fr_bw) - bg_bw);
    
    %thresh = thresh_v(i)
       
    for j=1:width
        for k=1:height
            if ((fr_diff(k,j) > thresh))
                fg(k,j) = fr_bw(k,j);
            else
                fg(k,j) = 0;
            end
        end
    end
    
    bg = fr; 
    
end

handles.thresh = thresh;

guidata(hObject,handles)

% sd_v_upper = get(handles.sd_v_upper,'value');
set(handles.slider1,'value',thresh_norm)
set(handles.slider1,'String',num2str(thresh));

axes(handles.axes1); 
imshow(uint8(fr_bw))
axes(handles.axes2);
imshow(uint8(fg))


% --- Outputs from this function are returned to the command line.
function varargout = bg_sub_gui_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on slider movement.
function slider1_Callback(hObject, eventdata, handles)
% hObject    handle to slider1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

source = aviread('C:\Video\Source\traffic\san_fran_traffic_30sec_QVGA');
% source = aviread('san_fran_traffic_30sec_QVGA_Cinepak');

slider1_val = get(handles.slider1,'value');
set(handles.slider1,'String',num2str(slider1_val));

thresh_norm = slider1_val;
thresh = thresh_norm*(255)           

bg = source(1).cdata;           % read in 1st frame as background frame
bg_bw = int8(rgb2gray(bg));

fr_size = size(bg);
width = fr_size(2);
height = fr_size(1);
fg = zeros(height, width);


for i = 2:60%length(source)
    
    fr = source(i).cdata;       % read in frame
    fr_bw = rgb2gray(fr);       % convert frame to grayscale
    
    fr_diff = abs(int8(fr_bw) - bg_bw);
    
    %thresh = thresh_v(i)
       
    for j=1:width
        for k=1:height
            if ((fr_diff(k,j) > thresh))
                fg(k,j) = fr_bw(k,j);
            else
                fg(k,j) = 0;
            end
        end
    end
    
    bg = fr;
    
 
    axes(handles.axes1); 
    imshow(uint8(fr_bw))
    axes(handles.axes2);
    imshow(uint8(fg))
    
    guidata(hObject, handles);
    set(handles.slider_val,'String',num2str(thresh));
end

% --- Executes during object creation, after setting all properties.
function slider1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


